<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\Statement;
use App\Models\Receipt;
use App\Models\StatementTransaction;

class Dashboard extends Component
{
    public $financeStats = [];
    public $userStats = [];

    public function mount()
    {
        $user = Auth::user();
        if ($user->hasRole('finance')) {
            $this->financeStats = [
                'open_statements' => Statement::where('status','open')->count(),
                'recent_transactions' => StatementTransaction::latest()->take(5)->get(),
                'unmatched_receipts' => Receipt::doesntHave('matches')->count(),
            ];
        } else {
            $this->userStats = [
                'my_receipts' => Receipt::where('user_id', $user->id)->latest()->take(5)->get(),
            ];
        }
    }

    public function render()
    {
        return view('livewire.dashboard');
    }
}
