<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('colourways', function (Blueprint $table) {
            if (Schema::hasColumn('colourways', 'name')) {
                $table->dropColumn('name');
            }
            if (Schema::hasColumn('colourways', 'color_code')) {
                $table->dropColumn('color_code');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('colourways', function (Blueprint $table) {
            if (!Schema::hasColumn('colourways', 'name')) {
                $table->string('name')->nullable();
            }
            if (!Schema::hasColumn('colourways', 'color_code')) {
                $table->string('color_code')->nullable();
            }
        });
    }
};


