<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;

class LibraryTrackResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        // Generate URLs for audio and transcript if they exist
        $audioUrl = null;
        $transcriptUrl = null;
        
        if ($this->audio_path) {
            try {
                $disk = Storage::disk('gcs');
                $audioUrl = $disk->temporaryUrl($this->audio_path, now()->addMinutes(10));
            } catch (\Throwable $e) {
                try {
                    $disk = Storage::disk('public');
                    $audioUrl = method_exists($disk, 'url') ? $disk->url($this->audio_path) : $this->audio_path;
                } catch (\Throwable $e) {
                    $audioUrl = $this->audio_path;
                }
            }
        }
        
        if ($this->transcript_path) {
            try {
                $disk = Storage::disk('gcs');
                $transcriptUrl = $disk->temporaryUrl($this->transcript_path, now()->addMinutes(10));
            } catch (\Throwable $e) {
                try {
                    $disk = Storage::disk('public');
                    $transcriptUrl = method_exists($disk, 'url') ? $disk->url($this->transcript_path) : $this->transcript_path;
                } catch (\Throwable $e) {
                    $transcriptUrl = $this->transcript_path;
                }
            }
        }

        return [
            'id' => $this->id,
            'category_id' => $this->category_id,
            'title' => $this->title,
            'slug' => $this->slug,
            'description' => $this->description,
            'duration_sec' => $this->duration_sec,
            'audio_url' => $audioUrl,
            'transcript_url' => $transcriptUrl,
            'tags' => $this->tags,
            'category' => $this->whenLoaded('category', function () {
                return [
                    'id' => $this->category->id,
                    'name' => $this->category->name,
                    'slug' => $this->category->slug,
                ];
            }),
            'published_at' => optional($this->published_at)->toISOString(),
        ];
    }
}
