<?php

namespace App\Models;

use App\Casts\Upper;
use App\Casts\Boolean;
use App\Casts\TitleCase;
use Illuminate\Support\Str;
use \Bkwld\Cloner\Cloneable;
use App\Models\BaseModel;
use OwenIt\Auditing\Contracts\Auditable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Services\TotalCacheService;

class CustomerOrders extends BaseModel implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes;
    use HasFactory;
    use Cloneable;
    public static function boot()
    {
        parent::boot();

        static::deleting(function($model) {
            $model->customer_order_lines?->each?->delete();
            $model->customer_order_files?->each?->delete();
        });
        static::restoring(function($model) {
            $model->customer_order_lines()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
            $model->customer_order_files()->withTrashed()->where('deleted_at', '>=', $model->deleted_at)->each(function ($item, $key) { $item->restore(); });
        });
        static::addGlobalScope('order', function (Builder $builder) {
            $builder->orderBy('order_date', 'desc');
        });
    }
    protected $casts = [
        'customer_po' =>Upper::class,
        'cust_ship_no' =>Upper::class,
        'asn' =>Upper::class,
        'order_date' => 'date:Y-m-d',
        'sent_to_factory' => 'date:Y-m-d',
        // 'cancelled' => Boolean::class,
        // 'incomplete_flag' => Boolean::class,
    ];

    protected $fillable = [
        'departments_id',
        'seasons_id',
        'customers_id',
        'customer_po',
        'order_date',
        'cancelled',
        // 'last_updated_by',
        'created_at',
        'updated_at',
        'incoterms',
        'cust_ship_no',
        'customer_addresses_id',
        'incomplete_flag',
        'order_type',
        'currency',
        'sent_to_factory',
        'deleted_at',
        'received',
        'shipment_mode',
        'phase_id',
    ];

    // protected function CustomerPo(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::upper($value),
    //     );
    // }
    // protected function Asn(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => Str::upper($value),
    //     );
    // }

	// public function scopeSearch($query, $value){
	// 	$query->where('customer_po', 'like', "%{$value}%")
	// 	->orWhereRelation('customer_order_lines.colourways', 'name', 'like', "%{$value}%")
	// 	->orWhereRelation('customer_order_lines.colourways.style_versions.styles', 'customer_ref', 'like', "%{$value}%")
	// 	->orWhereRelation('customer_order_lines.colourways.style_versions.styles', 'designs_id', 'like', "%{$value}%");
	// }

    public function scopeSearch($query, $value)
    {
        $sanitizedValue = preg_replace('/[^a-zA-Z0-9\s-]/', '', $value);
        // Split the search string into multiple terms
        $terms = preg_split('/\s+/', trim($value));

        $query->where(function($query) use ($terms) {
            foreach ($terms as $term) {
                // For each term, require at least one matching condition
                $query->where(function($q) use ($term) {
                    $q->where('customer_po', 'like', "%{$term}%")
                    ->orWhereRelation('customer_order_lines.colourways', 'name', 'like', "%{$term}%")
                    ->orWhereRelation('customer_order_lines.colourways.style_versions.styles.customers', 'name', 'like', "%{$term}%")
                    ->orWhereRelation('customer_order_lines.colourways.style_versions.factories', 'name', 'like', "%{$term}%")
                    ->orWhereRelation('customer_order_lines.colourways.style_versions.styles.designs', 'description', 'like', "%{$term}%")
                    ->orWhereRelation('customer_order_lines.colourways.style_versions.styles', 'customer_ref', 'like', "%{$term}%")
                    ->orWhereRelation('customer_order_lines.colourways.style_versions.styles', 'designs_id', 'like', "%{$term}%");
                });
            }
        });
    }

    // public function saveWithUser(){
    //     $this->last_updated_by = auth()->user()->id;
    //     $this->save();
    // }

    // protected function cancelled(): Attribute
    // {
    //     return Attribute::make(
    //         get: fn ($value) => empty($value) ? FALSE : $value, // number_format($value, 2, '.', ''),
    //         set: fn ($value) => empty($value) ? FALSE : $value, // empty($value) ? NULL : (preg_replace("/[^0-9.]/", "", $value) + 0),
    //     );
    // }

    public function getTotalSaleAttribute(){
        $total = 0;
        foreach($this->customer_order_lines as $col){
            foreach($col->customer_order_line_quantities as $colq){
                $total = $total + (($this->order_type == 'wholesale' ? $colq->priceModel['quote'] ?? 0 : $colq->price) * $colq->qty);
            }
        }
        return $total;
    }

    public function getTotalQtyAttribute(){
        return $this->customer_order_lines->sum(function ($line) {
            return $line->customer_order_line_quantities->sum('qty');
        });
    }

    public function departments()
    {
        return $this->belongsTo(Departments::class);
    }
    public function seasons()
    {
        return $this->belongsTo(Seasons::class);
    }
    public function customers()
    {
        return $this->belongsTo(Customer::class);
    }
    public function customer_addresses()
    {
        return $this->belongsTo(CustomerAddress::class, 'customer_addresses_id', 'id');
    }
    public function last_updated_by_user()
    {
        return $this->belongsTo(User::class, 'last_updated_by');
    }

	public function customer_order_lines()
    {
        return $this->hasMany(CustomerOrderLines::class);
    }
    public function customer_order_files()
    {
        return $this->hasMany(CustomerOrderFiles::class);
    }

    public function getTotalValueAttribute(){
        $i = 0;
        foreach($this->customer_order_lines as $line){
            $i = $i + $line->totalValue;
        }
        return number_format((float) $i, 2, '.', '');
    }


    // public function totalQty(){
    //     $i = 0;
    //     foreach($this->customer_order_lines as $line){
    //         $i = $i + $line->totalQty();
    //     }
    //     return $i;
    // }
}
