<?php

namespace App\Services\TTS\Drivers;

use App\DTO\AudioDTO;
use App\Services\Contracts\TTSService;

class NullTTSDriver implements TTSService
{
    public function synthesize(string $script, array $voice): AudioDTO
    {
        // Simulate an audio path
        return new AudioDTO('tts/null/' . md5($script) . '.mp3', 600, ['driver' => 'null']);
    }
}


