<?php

namespace App\Livewire\Profile;

use App\Contracts\ProfileService;
use Illuminate\Validation\Rule;
use Livewire\Attributes\Validate;
use Livewire\Component;

class Edit extends Component
{
    public ?string $display_name = null;
    public array $preferences = [];
    public array $sensitivity = [];

    public function mount(): void
    {
        $profile = auth()->user()->profile;
        if ($profile) {
            $this->display_name = $profile->display_name;
            $this->preferences = (array) $profile->preferences;
            $this->sensitivity = (array) $profile->sensitivity;
        }
    }

    public function save(ProfileService $profiles): void
    {
        $validated = $this->validate([
            'display_name' => ['nullable', 'string', 'max:120'],
            'preferences' => ['array'],
            'sensitivity' => ['array'],
        ]);

        $profiles->updateProfile(auth()->user(), $validated);

        $this->dispatch('toast', type: 'success', message: 'Profile updated');
    }

    public function render()
    {
        return view('livewire.profile.edit');
    }
}


