<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Tops',
                'slug' => 'tops',
                'description' => 'Shirts, blouses, t-shirts, and other upper body garments',
                'is_active' => true,
                'sort_order' => 1,
            ],
            [
                'name' => 'Bottoms',
                'slug' => 'bottoms',
                'description' => 'Pants, jeans, shorts, skirts, and other lower body garments',
                'is_active' => true,
                'sort_order' => 2,
            ],
            [
                'name' => 'Dresses',
                'slug' => 'dresses',
                'description' => 'One-piece garments including casual and formal dresses',
                'is_active' => true,
                'sort_order' => 3,
            ],
            [
                'name' => 'Outerwear',
                'slug' => 'outerwear',
                'description' => 'Jackets, coats, blazers, and other outer garments',
                'is_active' => true,
                'sort_order' => 4,
            ],
            [
                'name' => 'Accessories',
                'slug' => 'accessories',
                'description' => 'Bags, jewelry, scarves, belts, and other accessories',
                'is_active' => true,
                'sort_order' => 5,
            ],
            [
                'name' => 'Shoes',
                'slug' => 'shoes',
                'description' => 'Footwear including sneakers, boots, heels, and flats',
                'is_active' => true,
                'sort_order' => 6,
            ],
            [
                'name' => 'Activewear',
                'slug' => 'activewear',
                'description' => 'Athletic and workout clothing for sports and fitness',
                'is_active' => true,
                'sort_order' => 7,
            ],
            [
                'name' => 'Lingerie',
                'slug' => 'lingerie',
                'description' => 'Underwear, bras, sleepwear, and intimate apparel',
                'is_active' => true,
                'sort_order' => 8,
            ],
            [
                'name' => 'Swimwear',
                'slug' => 'swimwear',
                'description' => 'Bikinis, swimsuits, and beachwear',
                'is_active' => true,
                'sort_order' => 9,
            ],
            [
                'name' => 'Vintage',
                'slug' => 'vintage',
                'description' => 'Retro and vintage-inspired clothing pieces',
                'is_active' => false,
                'sort_order' => 10,
            ],
        ];

        foreach ($categories as $categoryData) {
            Category::updateOrCreate(
                ['slug' => $categoryData['slug']],
                $categoryData
            );
        }
    }
}
