<?php

namespace App\Contracts;

use App\Models\Track;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

interface LibraryService
{
    /**
     * List published tracks optionally filtered by tag slugs and level.
     *
     * @param array<int, string>|null $tagSlugs
     * @param string|null $level One of: beginner|intermediate|advanced
     */
    public function listTracks(?array $tagSlugs, ?string $level, int $perPage = 50, ?string $search = null): LengthAwarePaginator;

    /**
     * Create a short-lived signed URL (or best-effort public URL) for the given object key.
     */
    public function signMediaUrl(?string $objectKey, int $ttlSeconds = 300): ?string;

    /**
     * Convenience helper for a track's audio URL (key stored in DB).
     */
    public function getSignedAudioUrl(Track $track, int $ttlSeconds = 300): ?string;

    /**
     * Convenience helper for a track's image URL (key stored in DB).
     */
    public function getSignedImageUrl(Track $track, int $ttlSeconds = 300): ?string;
}


