<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('colourways', function (Blueprint $table) {
            $table->string('name')->after('items_id'); // Colorway name (e.g., "Red", "Blue", "Black/White")
            $table->string('reference')->nullable()->after('name'); // Reference code (e.g., "NAV-001", "RED-002")
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('colourways', function (Blueprint $table) {
            $table->dropColumn(['name', 'reference']);
        });
    }
};