<?php

namespace App\Http\Controllers;

use App\Services\CustomSessionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CustomSessionController extends Controller
{
    public function __construct(
        private CustomSessionService $customSessionService
    ) {}

    public function create()
    {
        return view('custom.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'topic' => 'required|string|max:255',
            'description' => 'required|string|max:1000',
            'duration_minutes' => 'required|integer|min:5|max:120',
            'voice_preference' => 'nullable|string|in:male,female,neutral',
            'special_notes' => 'nullable|string|max:1000',
            'goals' => 'nullable|array',
            'goals.*' => 'string|max:255',
        ]);

        $user = Auth::user();
        $customRequest = $this->customSessionService->createRequest($request->all(), $user);

        return redirect()->route('custom.sessions.index')
            ->with('success', 'Custom session request submitted successfully! We\'ll review it and get back to you soon.');
    }

    public function index(Request $request)
    {
        $user = Auth::user();
        $status = $request->get('status');
        
        $sessions = $this->customSessionService->getUserSessions($user, $status);

        return view('custom.index', compact('sessions', 'status'));
    }

    public function show(int $id)
    {
        $user = Auth::user();
        $session = $this->customSessionService->getSessionById($id, $user);

        if (!$session) {
            abort(404);
        }

        return view('custom.show', compact('session'));
    }
}
