<?php

namespace App\Jobs;

use App\Models\Receipt;
use App\Services\Finance\VatProcessingService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ProcessVatAnalysis implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public int $tries = 3;
    public int $timeout = 120; // Longer timeout for VAT processing
    public int $maxExceptions = 2;

    public function __construct(
        public int $receiptId,
        public ?string $trigger = 'finance_submission'
    ) {}

    public function handle(VatProcessingService $vatProcessor): void
    {
        $receipt = Receipt::with('lines')->find($this->receiptId);
        if (!$receipt) {
            return;
        }

        $vatProcessor->processReceiptVat($receipt);
    }
}
