<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // For SQLite, we need to recreate the table with the new enum values
        if (DB::getDriverName() === 'sqlite') {
            // Drop the unique constraint first
            DB::statement('DROP INDEX IF EXISTS unique_stmt_txn_receipt');
            
            // Create a temporary table with the new enum values
            Schema::create('transaction_matches_temp', function (Blueprint $table) {
                $table->id();
                $table->foreignId('statement_transaction_id')->constrained('statement_transactions')->cascadeOnDelete();
                $table->foreignId('receipt_id')->constrained('receipts')->cascadeOnDelete();
                $table->decimal('matched_amount', 12, 2);
                $table->enum('match_method', ['rule', 'llm', 'llm_intelligent', 'manual'])->default('rule');
                $table->decimal('amount_confidence', 5, 2)->nullable();
                $table->decimal('date_confidence', 5, 2)->nullable();
                $table->decimal('merchant_confidence', 5, 2)->nullable();
                $table->text('explanation')->nullable();
                $table->timestamps();
                $table->unique(['statement_transaction_id', 'receipt_id'], 'unique_stmt_txn_receipt');
            });

            // Copy data from old table to new table
            DB::statement('INSERT INTO transaction_matches_temp SELECT * FROM transaction_matches');

            // Drop old table and rename new table
            Schema::drop('transaction_matches');
            Schema::rename('transaction_matches_temp', 'transaction_matches');
        } else {
            // For other databases, alter the column
            DB::statement("ALTER TABLE transaction_matches MODIFY COLUMN match_method ENUM('rule', 'llm', 'llm_intelligent', 'manual') DEFAULT 'rule'");
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (DB::getDriverName() === 'sqlite') {
            // Recreate table with old enum values
            Schema::create('transaction_matches_temp', function (Blueprint $table) {
                $table->id();
                $table->foreignId('statement_transaction_id')->constrained('statement_transactions')->cascadeOnDelete();
                $table->foreignId('receipt_id')->constrained('receipts')->cascadeOnDelete();
                $table->decimal('matched_amount', 12, 2);
                $table->enum('match_method', ['rule', 'llm', 'manual'])->default('rule');
                $table->decimal('amount_confidence', 5, 2)->nullable();
                $table->decimal('date_confidence', 5, 2)->nullable();
                $table->decimal('merchant_confidence', 5, 2)->nullable();
                $table->text('explanation')->nullable();
                $table->timestamps();
                $table->unique(['statement_transaction_id', 'receipt_id'], 'unique_stmt_txn_receipt');
            });

            // Copy data back (excluding any llm_intelligent entries)
            DB::statement("INSERT INTO transaction_matches_temp SELECT * FROM transaction_matches WHERE match_method != 'llm_intelligent'");

            Schema::drop('transaction_matches');
            Schema::rename('transaction_matches_temp', 'transaction_matches');
        } else {
            DB::statement("ALTER TABLE transaction_matches MODIFY COLUMN match_method ENUM('rule', 'llm', 'manual') DEFAULT 'rule'");
        }
    }
};