<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">New Season</h1>
                <a href="{{ route('admin.seasons.index') }}" class="btn btn-outline-primary rounded-pill">Back</a>
            </div>

            <div class="card shadow-sm">
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.seasons.store') }}" class="row g-3">
                        @csrf
                        <div class="col-md-3">
                            <label class="form-label">Code</label>
                            <input type="text" name="code" class="form-control" placeholder="AW25" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Half</label>
                            <select name="half" class="form-select" required>
                                <option value="AW">Autumn/Winter (AW)</option>
                                <option value="SS">Spring/Summer (SS)</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Year</label>
                            <input type="number" name="year" class="form-control" min="2000" max="2100" value="{{ date('Y') }}" required>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" checked>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Label</label>
                            <input type="text" name="label" class="form-control" placeholder="Autumn/Winter 2025">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Image URL</label>
                            <input type="url" name="image_path" class="form-control" placeholder="https://...">
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description</label>
                            <textarea name="description" class="form-control" rows="4" placeholder="Season description..."></textarea>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Starts On</label>
                            <input type="date" name="starts_on" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Ends On</label>
                            <input type="date" name="ends_on" class="form-control">
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-primary rounded-pill">Create Season</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>


