<x-app-layout>
    <section class="py-4">
        <div class="container">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h4 mb-0">New Season</h1>
                <a href="{{ route('admin.seasons.index') }}" class="btn btn-outline-primary rounded-pill">Back</a>
            </div>

            @if($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="card shadow-sm">
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.seasons.store') }}" enctype="multipart/form-data" class="row g-3">
                        @csrf
                        <div class="col-md-3">
                            <label class="form-label">Code</label>
                            <input type="text" name="code" class="form-control" placeholder="AW25" value="{{ old('code') }}" required>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Half</label>
                            <select name="half" id="half" class="form-select" required>
                                <option value="AW" @selected(old('half')==='AW')>Autumn/Winter (AW)</option>
                                <option value="SS" @selected(old('half')==='SS')>Spring/Summer (SS)</option>
                            </select>
                        </div>
                        <div class="col-md-3">
                            <label class="form-label">Year</label>
                            <input type="number" name="year" id="year" class="form-control" min="2000" max="2100" value="{{ old('year', date('Y')) }}" required>
                        </div>
                        <div class="col-md-3 d-flex align-items-end">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="is_active" id="is_active" @checked(old('is_active', true))>
                                <label class="form-check-label" for="is_active">Active</label>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Label</label>
                            <input type="text" name="label" id="label" class="form-control" placeholder="Autumn/Winter 2025" value="{{ old('label') }}">
                            <small class="text-muted">Auto-filled from Half + Year. You can edit it.</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Season Image</label>
                            <input type="file" name="image" class="form-control" accept="image/*">
                            <small class="text-muted">JPG/PNG, up to 4MB</small>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Description</label>
                            <textarea name="description" class="form-control" rows="4" placeholder="Season description..."></textarea>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Starts On</label>
                            <input type="date" name="starts_on" class="form-control" value="{{ old('starts_on') }}">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Ends On</label>
                            <input type="date" name="ends_on" class="form-control" value="{{ old('ends_on') }}">
                        </div>

                        <div class="col-12">
                            <button type="submit" class="btn btn-primary rounded-pill">Create Season</button>
                        </div>
                    </form>
                </div>
            </div>
            
            <script>
                (function(){
                    const halfEl = document.getElementById('half');
                    const yearEl = document.getElementById('year');
                    const labelEl = document.getElementById('label');
                    const gen = () => {
                        const half = halfEl.value;
                        const year = yearEl.value;
                        if (!year) return;
                        const generated = (half === 'AW' ? 'Autumn/Winter ' : 'Spring/Summer ') + year;
                        if (!labelEl.value || labelEl.dataset.autofill === '1') {
                            labelEl.value = generated;
                            labelEl.dataset.autofill = '1';
                        }
                    };
                    halfEl.addEventListener('change', gen);
                    yearEl.addEventListener('input', gen);
                    labelEl.addEventListener('input', () => { labelEl.dataset.autofill = '0'; });
                    // Initial fill if empty
                    if (!labelEl.value) gen();
                })();
            </script>
        </div>
    </section>
</x-app-layout>


