<div class="dropdown">
    <button class="btn btn-outline-secondary btn-sm w-100 d-flex align-items-center justify-content-between" type="button" data-bs-toggle="dropdown">
        <div class="d-flex align-items-center">
            <i class="fas fa-columns text-primary me-2"></i>
            <span>Columns</span>
        </div>
        <span class="badge bg-secondary ms-2">{{ collect($columns)->where(true)->count() }}/{{ count($columns) }}</span>
    </button>
    <ul class="dropdown-menu dropdown-menu-end w-100" style="max-height: 50vh; overflow-y: auto;">
        @if (Session::get('message'))
            <li><div class="alert {{ Session::get('alert-class') }} alert-sm mb-2 mx-2" role="alert">{{ Session::get('message') }}</div></li>
        @endif
        @if($errors->all())
            <li><div class="alert {{ Session::get('alert-class') ?? 'alert-dark' }} alert-sm mb-2 mx-2" role="alert">
                @foreach ($errors->all() as $error)
                    {{ $error }}<br>
                @endforeach
            </div></li>
        @endif
        <li>
            <div class="btn-group w-100 mb-2 px-2">
                <button class="btn btn-outline-primary btn-sm" wire:click="toggleAllColumns(true)">All</button>
                <button class="btn btn-outline-secondary btn-sm" wire:click="toggleAllColumns(false)">None</button>
            </div>
        </li>
        @foreach($columns as $key => $column)
            <li>
                <button class="dropdown-item d-flex align-items-center @if($column) active @endif" wire:click="$set('columns.{{ $key }}', !{{ $column ? 'true' : 'false' }})">
                    <input class="form-check-input me-2" type="checkbox" {{ $column ? 'checked' : '' }} readonly>
                    <span>{{ $key }}</span>
                </button>
            </li>
        @endforeach
    </ul>
</div>
