<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\Item;

class SearchBar extends Component
{
    public $search = '';
    public $results = [];
    public $showResults = false;

    public function updatedSearch()
    {
        if (strlen($this->search) < 2) {
            $this->results = [];
            $this->showResults = false;
            return;
        }

        $this->results = Item::where(function($query) {
                $query->where('name', 'like', '%' . $this->search . '%')
                      ->orWhere('description', 'like', '%' . $this->search . '%')
                      ->orWhere('sku', 'like', '%' . $this->search . '%');
            })
            ->with(['season', 'category'])
            ->limit(8)
            ->get();

        $this->showResults = true;
    }

    public function selectResult()
    {
        $this->showResults = false;
        $this->search = '';
    }

    public function render()
    {
        return view('livewire.search-bar');
    }
}

