# Superuser Portal - Quick Start Guide

## What is the Superuser Portal?

The Superuser Portal is an admin interface for managing your Vybe Photo platform. It allows you to:

- 👥 Manage all user accounts
- 💎 Create and manage subscription tiers
- 📊 Monitor platform metrics and revenue
- 🔍 View detailed user statistics
- 📋 Track all administrative actions
- ⚙️ Adjust user limits and subscriptions

## Quick Setup (5 minutes)

### Step 1: Run the Migration

```bash
# Make sure your PostgreSQL database is running
# Then run the superuser migration
psql -h localhost -U postgres -d photowebsite -f migrations/002-add-superuser-support.sql
```

This creates the necessary database tables and columns for superuser functionality.

### Step 2: Create Your Superuser Account

```bash
# Run the setup script
./setup-superuser.sh
```

The script will ask you for:
- Username (e.g., `admin`)
- Email address
- Password (twice for confirmation)

### Step 3: Start the Server

```bash
# Start your server (if not already running)
node src/server-multi-tenant.js
```

### Step 4: Log In

1. Open your browser to `http://app.localhost:3000/login` (or your configured app domain)
2. Log in with your superuser credentials
3. Click on "Superuser Portal" in the navigation or go to `/superuser`

That's it! You now have access to the superuser portal.

## Common Tasks

### View All Users

1. Go to `/superuser/users`
2. Search, filter, or sort users as needed
3. Click "Edit" on any user to manage them

### Change a User's Subscription Tier

1. Go to `/superuser/users` and find the user
2. Click "Edit"
3. Scroll to "Subscription Details"
4. Select a new tier from the dropdown
5. Click "Update Tier"

### Create a New Subscription Tier

1. Go to `/superuser/tiers`
2. Click "Create New Tier"
3. Fill in the details:
   - Tier key: `premium` (unique identifier)
   - Tier name: `Premium` (display name)
   - Price: `15.00` (monthly price in £)
   - Max photos: `5000`
   - Max storage: `25` (GB)
   - Check "Custom domain" if applicable
4. Add feature descriptions
5. Click "Create Tier"

### Suspend a User Account

1. Go to `/superuser/users/:id` for the user
2. Scroll to "Administrative Actions"
3. Click "Suspend Account"
4. Optionally add a reason
5. Confirm suspension

### View Platform Statistics

1. Go to `/superuser` (dashboard)
2. View stats:
   - Total users and growth
   - Monthly Recurring Revenue (MRR)
   - Storage and photo usage
   - Recent activity

## Portal Navigation

- **Dashboard** (`/superuser`) - Overview and statistics
- **Users** (`/superuser/users`) - User management
- **Tiers** (`/superuser/tiers`) - Subscription tier management
- **Audit Log** (`/superuser/audit-log`) - All admin actions

## Tips

### Making Another User a Superuser

If you want to give someone else superuser access:

1. Go to `/superuser/users/:id` for that user
2. Click "Make Superuser" button
3. They can now access the superuser portal

Or via SQL:
```sql
UPDATE users SET is_superuser = TRUE WHERE email = 'user@example.com';
```

### Accessing User Galleries

From any user's edit page, click their gallery link to view their site.

### Custom Limits

If you want to give a user custom limits (outside their tier):

1. Go to their edit page
2. Scroll to "Usage Statistics"
3. Enter custom photo limit and storage limit
4. Click "Update Limits"

This overrides their tier's default limits.

## Security Notes

- ⚠️ **Superuser accounts have full platform access** - only create them for trusted admins
- 🔒 Use strong passwords for superuser accounts
- 📋 All superuser actions are logged in the audit log
- 🚫 Superusers cannot delete other superusers (safety feature)

## Troubleshooting

### "Access Denied" Error

**Problem**: You can't access `/superuser`

**Solution**: 
1. Make sure you're logged in
2. Verify your account has `is_superuser = TRUE`:
   ```sql
   SELECT username, email, is_superuser FROM users WHERE email = 'your@email.com';
   ```
3. If false, update it:
   ```sql
   UPDATE users SET is_superuser = TRUE WHERE email = 'your@email.com';
   ```

### Can't Log In

**Problem**: Login not working

**Solution**:
- Check your username and password
- Make sure you're on the app subdomain (`app.localhost` or `app.yourdomain.com`)
- Verify your account exists in the database

### Setup Script Fails

**Problem**: `./setup-superuser.sh` fails

**Solutions**:
- Make sure PostgreSQL is running
- Check your `.env` file has correct database credentials
- Verify bcrypt is installed: `npm install bcrypt`
- Make sure the script is executable: `chmod +x setup-superuser.sh`

## Need More Help?

See the full guide: [SUPERUSER-GUIDE.md](SUPERUSER-GUIDE.md)

## Feature Highlights

### User Management
- ✅ Search and filter users
- ✅ View usage statistics
- ✅ Update subscription tiers
- ✅ Suspend/activate accounts
- ✅ Set custom limits
- ✅ Delete accounts

### Tier Management
- ✅ Create unlimited tiers
- ✅ Set pricing and limits
- ✅ Enable/disable custom domains
- ✅ Add feature lists
- ✅ Activate/deactivate tiers

### Analytics
- ✅ MRR and ARR tracking
- ✅ Revenue breakdown by tier
- ✅ User growth metrics
- ✅ Engagement statistics
- ✅ Storage and photo usage

### Audit Trail
- ✅ Complete action history
- ✅ Admin and target user tracking
- ✅ IP address logging
- ✅ Detailed action metadata

---

**Ready to start?** Run `./setup-superuser.sh` now!

