<?php

namespace App\Livewire\Manage;

use Livewire\Component;
use App\Models\Statement;
use Livewire\Attributes\On;

class StatementsList extends Component
{
    public $statements;

    public function mount()
    {
        $this->statements = Statement::withCount(['transactions as matched_count' => function($q){
            $q->whereHas('matches');
        }, 'transactions as total_count'])
            ->latest('period_end')
            ->take(20)
            ->get();
    }

    #[On('refresh-statements')]
    public function refreshList(): void
    {
        $this->mount();
    }

    public function select(int $statementId)
    {
        $this->dispatch('select-statement', statementId: $statementId);
    }

    public function render()
    {
        return view('livewire.manage.statements-list');
    }
}


