<?php

namespace App\Services;

use App\Models\Receipt;
use App\Services\Matching\ClassificationService;
use App\Services\VAT\UkVatService;
use App\Services\Matching\ReceiptMatchingService;

class ReceiptProcessingService
{
    public function __construct(
        private ClassificationService $classification,
        private UkVatService $vat,
        private ReceiptMatchingService $matching,
    ) {}

    public function process(Receipt $receipt): void
    {
        $this->classification->classifyReceipt($receipt);
        foreach ($receipt->lines as $line) {
            $this->classification->classifyReceiptLine($line);
            $this->vat->analyzeLine($line);
        }
        $this->matching->attemptMatchForReceipt($receipt);
    }
}


