<?php

namespace App\Services;

use App\Models\Receipt;
use App\Services\Matching\ClassificationService;
use App\Services\VAT\UkVatService;
use App\Services\Matching\ReceiptMatchingService;
use App\Services\OCR\ReceiptOCRService;

class ReceiptProcessingService
{
    public function __construct(
        private ReceiptOCRService $ocr,
        private ClassificationService $classification,
        private UkVatService $vat,
        private ReceiptMatchingService $matching,
    ) {}

    public function process(Receipt $receipt): void
    {
        // First extract data from the receipt image using OCR
        $this->ocr->extractReceiptData($receipt);
        
        // Refresh the receipt to get the updated data and lines
        $receipt->refresh();
        
        // Then classify the receipt and its lines
        $this->classification->classifyReceipt($receipt);
        foreach ($receipt->lines as $line) {
            $this->classification->classifyReceiptLine($line);
            $this->vat->analyzeLine($line);
        }
        
        // Finally attempt to match the receipt to statement transactions
        $this->matching->attemptMatchForReceipt($receipt);
    }
}


