<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use App\Services\Matching\TransactionClassificationService;
use App\Models\StatementTransaction;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

Artisan::command('classify:transactions {--limit=50}', function () {
    $limit = (int) $this->option('limit') ?: 50;
    /** @var TransactionClassificationService $service */
    $service = app(TransactionClassificationService::class);
    $txns = StatementTransaction::with('matches.receipt.lines')->limit($limit)->get();
    $this->info('Classifying '.$txns->count().' transactions...');
    foreach ($txns as $t) {
        try {
            $service->classify($t);
            $this->line('✓ Txn #'.$t->id.' '.$t->merchant_name.' £'.$t->amount);
        } catch (\Throwable $e) {
            $this->error('Error #'.$t->id.': '.$e->getMessage());
        }
    }
    $this->info('Done.');
})->purpose('Run LLM classification over a batch of transactions');
