<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

// Queue a small batch of finance classification jobs for testing
Artisan::command('classify:test {count=5}', function (int $count = 5) {
    $txns = \App\Models\StatementTransaction::orderBy('id')->limit($count)->get();
    foreach ($txns as $t) {
        \App\Jobs\ClassifyTransaction::dispatch($t->id, false);
        $this->info('Queued txn #'.$t->id.' - '.$t->merchant_name);
    }
    $this->info('Queued '.$txns->count().' classification job(s).');
})->purpose('Queue a small batch of classification jobs for testing');
