<?php

namespace App\Contracts;

use App\Models\SafetyEvent;
use App\Models\User;

interface SafetyService
{
    /**
     * Evaluate text for safety policy and return the chosen action, rule code, and minimal excerpt.
     * @return array{action:string, rule_code:string, excerpt:?string}
     */
    public function evaluateText(string $text): array;

    /**
     * Run checks and persist a SafetyEvent with minimal, scrubbed context.
     */
    public function checkAndLog(string $context, string $text, ?User $user = null): SafetyEvent;

    /**
     * Redact sensitive PII while preserving the meaning and length of text.
     */
    public function redact(string $text): string;
}


