<?php

namespace App\Contracts;

use App\Models\SafetyEvent;
use App\Models\User;

interface SafetyService
{
    /**
     * Check user-provided input text and return a decision.
     * @return array{action:string, flags:array<int,string>, redactedText:?string}
     */
    public function checkInput(string $text): array;

    /**
     * Check system/output text and return a decision.
     * @return array{action:string, flags:array<int,string>, redactedText:?string}
     */
    public function checkOutput(string $text): array;

    /** Log a SafetyEvent with minimal, scrubbed context. */
    public function checkAndLog(string $context, string $text, ?User $user = null): SafetyEvent;

    /** Redact sensitive PII while preserving meaning where possible. */
    public function redact(string $text): string;
}


