<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" data-bs-theme="light">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Admin Panel') - {{ config('app.name', 'Laravel') }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    <!-- Scripts -->
    @vite(['resources/sass/app.scss', 'resources/js/app.js'])
    @livewireStyles
    
    <!-- Bootstrap 5 with Dark Mode -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    
    <!-- Custom Admin Styles -->
    <style>
        .sidebar {
            min-height: 100vh;
            width: 250px;
            position: fixed;
            top: 0;
            left: 0;
            z-index: 1000;
            transition: all 0.3s ease;
        }
        
        .main-content {
            margin-left: 250px;
            min-height: 100vh;
            transition: all 0.3s ease;
        }
        
        .sidebar.collapsed {
            width: 60px;
        }
        
        .sidebar.collapsed + .main-content {
            margin-left: 60px;
        }
        
        .sidebar.collapsed .nav-text {
            display: none;
        }
        
        .nav-link {
            color: var(--bs-nav-link-color);
            transition: all 0.2s ease;
        }
        
        .nav-link:hover {
            background-color: var(--bs-secondary-bg);
            color: var(--bs-emphasis-color);
        }
        
        .nav-link.active {
            background-color: var(--bs-primary);
            color: var(--bs-primary-text);
        }
        
        .page-transition {
            opacity: 0;
            transition: opacity 0.2s ease-in-out;
        }
        
        .page-transition.loaded {
            opacity: 1;
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .sidebar.show {
                transform: translateX(0);
            }
            
            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>

<body>
    <div class="d-flex">
        <!-- Sidebar -->
        <nav class="sidebar bg-body-tertiary border-end">
            <div class="p-3">
                <div class="d-flex align-items-center">
                    <i class="bi bi-shop me-2 fs-4 text-primary"></i>
                    <span class="nav-text fw-bold">Admin Panel</span>
                </div>
            </div>
            
            <div class="px-3 pb-3">
                <button class="btn btn-outline-secondary btn-sm w-100 mb-3" onclick="toggleSidebar()">
                    <i class="bi bi-list"></i>
                    <span class="nav-text ms-2">Toggle Menu</span>
                </button>
            </div>
            
            <ul class="nav nav-pills flex-column px-3">
                <li class="nav-item mb-1">
                    <a class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}" href="{{ route('admin.dashboard') }}">
                        <i class="bi bi-speedometer2 me-2"></i>
                        <span class="nav-text">Dashboard</span>
                    </a>
                </li>
                <li class="nav-item mb-1">
                    <a class="nav-link {{ request()->routeIs('admin.orders*') ? 'active' : '' }}" href="{{ route('admin.orders') }}">
                        <i class="bi bi-cart-check me-2"></i>
                        <span class="nav-text">Orders</span>
                    </a>
                </li>
                <li class="nav-item mb-1">
                    <a class="nav-link {{ request()->routeIs('admin.customers*') ? 'active' : '' }}" href="{{ route('admin.customers') }}">
                        <i class="bi bi-people me-2"></i>
                        <span class="nav-text">Customers</span>
                    </a>
                </li>
                <li class="nav-item mb-1">
                    <a class="nav-link {{ request()->routeIs('admin.seasons*') ? 'active' : '' }}" href="{{ route('admin.seasons') }}">
                        <i class="bi bi-calendar3 me-2"></i>
                        <span class="nav-text">Seasons</span>
                    </a>
                </li>
                <li class="nav-item mb-1">
                    <a class="nav-link {{ request()->routeIs('admin.categories*') ? 'active' : '' }}" href="{{ route('admin.categories') }}">
                        <i class="bi bi-tags me-2"></i>
                        <span class="nav-text">Categories</span>
                    </a>
                </li>
                <li class="nav-item mb-1">
                    <a class="nav-link {{ request()->routeIs('admin.items*') ? 'active' : '' }}" href="{{ route('admin.items') }}">
                        <i class="bi bi-box me-2"></i>
                        <span class="nav-text">Items</span>
                    </a>
                </li>
                
            </ul>
            
            <div class="mt-auto p-3">
                <div class="border-top pt-3">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="d-flex align-items-center">
                            <i class="bi bi-person-circle me-2 fs-5"></i>
                            <div class="nav-text">
                                <div class="fw-semibold">{{ Auth::user()->name }}</div>
                                <small class="text-muted">{{ Auth::user()->role }}</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mt-3">
                        <a href="{{ route('logout') }}" class="btn btn-outline-danger btn-sm w-100" 
                           onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="bi bi-box-arrow-right me-2"></i>
                            <span class="nav-text">Logout</span>
                        </a>
                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <div class="main-content flex-grow-1">
            <!-- Header -->
            <header class="bg-body border-bottom">
                <div class="container-fluid">
                    <div class="d-flex align-items-center justify-content-between py-3">
                        <div>
                            <h1 class="h4 mb-0">@yield('page-title', 'Dashboard')</h1>
                            <p class="text-muted mb-0">@yield('page-description', 'Welcome to the admin panel')</p>
                        </div>
                        
                        <div class="d-flex align-items-center gap-3">
                            <!-- Theme Toggle -->
                            <button class="btn btn-outline-secondary" onclick="toggleTheme()" title="Toggle theme">
                                <i class="bi bi-sun" id="theme-icon"></i>
                            </button>
                            
                            <!-- Mobile Menu Toggle -->
                            <button class="btn btn-outline-secondary d-md-none" onclick="toggleMobileSidebar()">
                                <i class="bi bi-list"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </header>

            <!-- Page Content -->
            <main class="container-fluid py-4">
                <div class="page-transition" id="main-content">
                    {{ $slot }}
                </div>
            </main>
        </div>
    </div>

    @livewireScripts
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Admin Scripts -->
    <script>
        // Theme Management
        function initTheme() {
            const savedTheme = localStorage.getItem('theme') || 'light';
            setTheme(savedTheme);
        }
        
        function setTheme(theme) {
            document.documentElement.setAttribute('data-bs-theme', theme);
            const icon = document.getElementById('theme-icon');
            icon.className = theme === 'dark' ? 'bi bi-moon' : 'bi bi-sun';
            localStorage.setItem('theme', theme);
        }
        
        function toggleTheme() {
            const currentTheme = document.documentElement.getAttribute('data-bs-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            setTheme(newTheme);
        }
        
        // Sidebar Management
        function toggleSidebar() {
            const sidebar = document.querySelector('.sidebar');
            sidebar.classList.toggle('collapsed');
        }
        
        function toggleMobileSidebar() {
            const sidebar = document.querySelector('.sidebar');
            sidebar.classList.toggle('show');
        }
        
        // Page Transitions
        function showPageContent() {
            const content = document.getElementById('main-content');
            content.classList.add('loaded');
        }
        
        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            initTheme();
            showPageContent();
        });
        
        // Handle Livewire navigation
        document.addEventListener('livewire:navigating', function() {
            const content = document.getElementById('main-content');
            content.classList.remove('loaded');
        });
        
        document.addEventListener('livewire:navigated', function() {
            showPageContent();
        });
        
        // Close mobile sidebar when clicking outside
        document.addEventListener('click', function(e) {
            const sidebar = document.querySelector('.sidebar');
            const mobileToggle = document.querySelector('[onclick="toggleMobileSidebar()"]');
            
            if (window.innerWidth <= 768 && 
                !sidebar.contains(e.target) && 
                !mobileToggle.contains(e.target)) {
                sidebar.classList.remove('show');
            }
        });
    </script>
</body>
</html>