<div class="max-w-4xl mx-auto py-8 px-4 sm:px-6 lg:px-8">
    <div class="bg-white rounded-2xl shadow-md p-8">
        <div class="text-center mb-8">
            <h1 class="text-3xl font-quicksand font-semibold text-neutral-800 mb-2">
                Request Your Custom Session
            </h1>
            <p class="text-neutral-600 text-lg">
                Tell us about your wellness goals and we'll create a personalized session just for you.
            </p>
        </div>

        <form wire:submit="submit" class="space-y-6">
            <!-- Topic -->
            <div>
                <label for="topic" class="block text-sm font-medium text-neutral-700 mb-2">
                    Session Topic *
                </label>
                <input 
                    type="text" 
                    id="topic" 
                    wire:model="topic"
                    class="w-full px-4 py-3 border border-neutral-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                    placeholder="e.g., Public Speaking Confidence, Work-Life Balance"
                    required
                >
                @error('topic') 
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Description -->
            <div>
                <label for="description" class="block text-sm font-medium text-neutral-700 mb-2">
                    Detailed Description *
                </label>
                <textarea 
                    id="description" 
                    wire:model="description"
                    rows="4"
                    class="w-full px-4 py-3 border border-neutral-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                    placeholder="Describe your specific needs, challenges, and what you hope to achieve from this session..."
                    required
                ></textarea>
                @error('description') 
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Session Length -->
            <div>
                <label for="session_length" class="block text-sm font-medium text-neutral-700 mb-2">
                    Session Length *
                </label>
                <select 
                    id="session_length" 
                    wire:model="session_length"
                    class="w-full px-4 py-3 border border-neutral-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                    required
                >
                    <option value="">Select session length</option>
                    <option value="15min">15 minutes</option>
                    <option value="30min">30 minutes</option>
                    <option value="45min">45 minutes</option>
                    <option value="60min">60 minutes</option>
                </select>
                @error('session_length') 
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Voice Preference -->
            <div>
                <label for="voice_preference" class="block text-sm font-medium text-neutral-700 mb-2">
                    Voice Preference *
                </label>
                <select 
                    id="voice_preference" 
                    wire:model="voice_preference"
                    class="w-full px-4 py-3 border border-neutral-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                    required
                >
                    <option value="">Select voice preference</option>
                    <option value="female">Female</option>
                    <option value="male">Male</option>
                    <option value="neutral">Neutral</option>
                </select>
                @error('voice_preference') 
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Special Notes -->
            <div>
                <label for="special_notes" class="block text-sm font-medium text-neutral-700 mb-2">
                    Special Notes or Preferences
                </label>
                <textarea 
                    id="special_notes" 
                    wire:model="special_notes"
                    rows="3"
                    class="w-full px-4 py-3 border border-neutral-300 rounded-xl focus:ring-2 focus:ring-primary-500 focus:border-transparent transition-all"
                    placeholder="Any specific techniques, approaches, or considerations you'd like us to include..."
                ></textarea>
                @error('special_notes') 
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>

            <!-- Submit Button -->
            <div class="pt-6">
                <button 
                    type="submit"
                    class="w-full bg-primary-500 hover:bg-primary-600 text-white font-semibold py-3 px-6 rounded-full transition-all duration-200 transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-primary-500 focus:ring-offset-2"
                    wire:loading.attr="disabled"
                    wire:loading.class="opacity-50 cursor-not-allowed"
                >
                    <span wire:loading.remove>Submit Custom Session Request</span>
                    <span wire:loading>Processing...</span>
                </button>
            </div>
        </form>

        <!-- Success Message -->
        @if (session()->has('message'))
            <div class="mt-6 p-4 bg-green-50 border border-green-200 rounded-xl">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-400" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-green-800">{{ session('message') }}</p>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>
