<x-app-layout>
    <!-- Hero Section -->
    <section class="collections-hero position-relative overflow-hidden bg-dark text-white py-5">
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center py-5">
                <div class="col-lg-8">
                    <div class="collections-hero-content" data-aos="fade-up">
                        <nav aria-label="breadcrumb" class="mb-4">
                            <ol class="breadcrumb breadcrumb-dark">
                                <li class="breadcrumb-item"><a href="/" class="text-light text-decoration-none">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Collections</li>
                            </ol>
                        </nav>
                        
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-collection me-2"></i>Seasonal Collections
                        </span>
                        
                        <h1 class="display-3 fw-light mb-4 text-white">
                            Seasonal Collections
                            <span class="d-block fw-normal fs-2 mt-2 text-light">Discover Our Yarns by Season</span>
                        </h1>
                        
                        <p class="lead mb-4 text-light opacity-90">
                            Explore our curated selection of the world's finest yarns organized by season. 
                            Each collection brings its own unique character, colour palette, and fibre selection.
                        </p>
                        
                        <div class="d-flex gap-3 flex-wrap">
                            <a href="#seasons" class="btn btn-primary btn-lg px-4 py-3">
                                <i class="bi bi-arrow-down me-2"></i>Browse Collections
                            </a>
                            <a href="/" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-house me-2"></i>Back to Home
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="collections-hero-image text-center" data-aos="fade-left">
                        <div class="collections-icon-large mb-4">
                            <i class="bi bi-collection display-1 text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="collections-hero-pattern"></div>
    </section>

    <!-- Seasons Overview -->
    @if($activeSeasons->count() > 0)
        <section id="seasons" class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Our Seasonal Collections</h2>
                    <p class="text-muted lead">Each season brings its own unique character and colour palette</p>
                </div>
                
                <div class="row g-4">
                    @foreach($activeSeasons as $index => $season)
                        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="season-card h-100 rounded shadow-sm border-0 overflow-hidden">
                                <div class="row g-0 h-100">
                                    <div class="col-md-4">
                                        @if($season->image_path)
                                            <div class="season-image h-100">
                                                <img src="{{ $season->image_path }}" class="w-100 h-100 object-fit-cover" alt="{{ $season->code }} Collection">
                                            </div>
                                        @else
                                            <div class="season-icon text-center h-100 d-flex flex-column align-items-center justify-content-center bg-light">
                                                <div class="season-icon-circle mb-3">
                                                    <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} display-4 text-primary"></i>
                                                </div>
                                                <h5 class="fw-semibold text-primary">{{ $season->code }}</h5>
                                                <small class="text-muted">{{ $season->label }}</small>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-8 p-4">
                                        <h4 class="fw-semibold mb-3">{{ $season->code }}</h4>
                                        <p class="text-muted mb-3">
                                            {{ $season->description }}
                                        </p>
                                        @if($season->starts_on && $season->ends_on)
                                            <p class="text-muted small mb-3">
                                                <i class="bi bi-calendar-event me-2"></i>
                                                Available: {{ \Carbon\Carbon::parse($season->starts_on)->format('M Y') }} - {{ \Carbon\Carbon::parse($season->ends_on)->format('M Y') }}
                                            </p>
                                        @endif
                                        <a href="{{ route('collection.detail', $season->code) }}" class="btn btn-primary">
                                            <i class="bi bi-arrow-right me-2"></i>Explore {{ $season->code }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Call to Action -->
    <section class="py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="cta-content" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-4">Ready to Start Your Project?</h2>
                        <p class="lead mb-4 opacity-90">
                            Browse our seasonal collections to find the perfect yarns for your next creation.
                        </p>
                        <div class="d-flex gap-3 justify-content-center flex-wrap">
                            <a href="/" class="btn btn-light btn-lg px-4 py-3">
                                <i class="bi bi-house me-2"></i>Back to Home
                            </a>
                            <a href="#seasons" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-arrow-up me-2"></i>Browse Collections
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert yarn insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
