<x-app-layout>
    <!-- Hero Section -->
    <section class="collections-hero position-relative overflow-hidden bg-dark text-white py-5">
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center py-5">
                <div class="col-lg-8">
                    <div class="collections-hero-content" data-aos="fade-up">
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-collection me-2"></i>Our Collections
                        </span>
                        <h1 class="display-3 fw-light mb-4 text-white">
                            Discover Our Collections
                            <span class="d-block fw-normal fs-2 mt-2 text-light">Seasonal Luxury Yarns</span>
                        </h1>
                        <p class="lead mb-0 text-light opacity-90">
                            Explore our curated selection of the world's finest yarns, organized by season and category. 
                            Each collection tells a story of heritage, quality, and timeless elegance.
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <div class="collections-hero-pattern"></div>
    </section>

    <!-- Seasons Overview -->
    @if($activeSeasons->count() > 0)
        <section class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Seasonal Collections</h2>
                    <p class="text-muted lead">Each season brings its own unique character and colour palette</p>
                </div>
                
                <div class="row g-4">
                    @foreach($activeSeasons as $index => $season)
                        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="season-card h-100 p-4 rounded shadow-sm border-0">
                                <div class="row g-4 align-items-center">
                                    <div class="col-md-4">
                                        <div class="season-icon text-center">
                                            <div class="season-icon-circle mb-3">
                                                <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} display-4 text-primary"></i>
                                            </div>
                                            <h5 class="fw-semibold text-primary">{{ $season->code }}</h5>
                                            <small class="text-muted">{{ $season->label }}</small>
                                        </div>
                                    </div>
                                    <div class="col-md-8">
                                        <h4 class="fw-semibold mb-3">{{ $season->code }} Collection</h4>
                                        <p class="text-muted mb-3">
                                            {{ $season->description }}
                                        </p>
                                        @if($season->starts_on && $season->ends_on)
                                            <p class="text-muted small mb-3">
                                                <i class="bi bi-calendar-event me-2"></i>
                                                Available: {{ \Carbon\Carbon::parse($season->starts_on)->format('M Y') }} - {{ \Carbon\Carbon::parse($season->ends_on)->format('M Y') }}
                                            </p>
                                        @endif
                                        <a href="#" class="btn btn-primary">
                                            <i class="bi bi-arrow-right me-2"></i>Explore {{ $season->code }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Categories Section -->
    @if($featuredCategories->count() > 0)
        <section class="py-5 bg-light">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Yarn Categories</h2>
                    <p class="text-muted lead">Browse our yarns by type and application</p>
                </div>
                
                <div class="row g-4">
                    @foreach($featuredCategories as $index => $category)
                        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="category-card h-100 p-4 rounded shadow-sm border-0 bg-white">
                                <div class="category-icon mb-3">
                                    <i class="bi bi-palette2 display-4 text-primary"></i>
                                </div>
                                <h5 class="fw-semibold mb-3">{{ $category->name }}</h5>
                                @if($category->description)
                                    <p class="text-muted mb-3">{{ $category->description }}</p>
                                @endif
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="badge bg-primary-subtle text-primary">{{ $category->items_count ?? 0 }} items</span>
                                    <a href="#" class="btn btn-outline-primary btn-sm">
                                        <i class="bi bi-arrow-right me-1"></i>View
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Featured Items -->
    @if($latestItems->count() > 0)
        <section class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Featured Items</h2>
                    <p class="text-muted lead">Discover our latest additions and most popular yarns</p>
                </div>
                
                <div class="row g-4">
                    @foreach($latestItems as $index => $item)
                        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="item-card h-100 rounded shadow-sm border-0 overflow-hidden">
                                <div class="item-image position-relative">
                                    <div class="ratio ratio-4x3">
                                        <img src="https://as2.ftcdn.net/v2/jpg/03/65/51/06/1000_F_365510635_E8b3EsXrTq7F4QyYxw0qBz1lWY0eH6gS.jpg" 
                                             class="w-100 h-100 object-fit-cover" alt="{{ $item->name }}">
                                    </div>
                                    @if($item->season)
                                        <div class="item-season-badge">
                                            <span class="badge bg-primary">{{ $item->season->code }}</span>
                                        </div>
                                    @endif
                                </div>
                                <div class="item-content p-4">
                                    <h6 class="fw-semibold mb-2">{{ $item->name }}</h6>
                                    @if($item->category)
                                        <p class="text-muted small mb-2">{{ $item->category->name }}</p>
                                    @endif
                                    @if($item->description)
                                        <p class="text-muted small mb-3">{{ Str::limit($item->description, 80) }}</p>
                                    @endif
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-primary fw-semibold">View Details</span>
                                        <a href="#" class="btn btn-outline-primary btn-sm">
                                            <i class="bi bi-arrow-right"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
                
                <div class="text-center mt-5" data-aos="fade-up">
                    <a href="#" class="btn btn-primary btn-lg px-5">
                        <i class="bi bi-grid-3x3-gap me-2"></i>View All Items
                    </a>
                </div>
            </div>
        </section>
    @endif

    <!-- Call to Action -->
    <section class="py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <h2 class="fw-light display-6 mb-4">Ready to Start Your Project?</h2>
                    <p class="lead mb-4 opacity-90">
                        Our team of textile specialists is here to help you find the perfect yarn for your next creation.
                    </p>
                    <div class="d-flex gap-3 justify-content-center flex-wrap">
                        <a href="#newsletter" class="btn btn-light btn-lg px-4">
                            <i class="bi bi-envelope me-2"></i>Get Updates
                        </a>
                        <a href="#" class="btn btn-outline-light btn-lg px-4">
                            <i class="bi bi-chat-dots me-2"></i>Contact Us
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert knitting insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
