<x-app-layout>
    <!-- Hero Section -->
    <section class="collections-hero position-relative overflow-hidden bg-dark text-white py-5">
        <div class="container position-relative" style="z-index: 2;">
            <div class="row align-items-center py-5">
                <div class="col-lg-8">
                    <div class="collections-hero-content" data-aos="fade-up">
                        <nav aria-label="breadcrumb" class="mb-4">
                            <ol class="breadcrumb breadcrumb-dark">
                                <li class="breadcrumb-item"><a href="/" class="text-light text-decoration-none">Home</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Collections</li>
                            </ol>
                        </nav>
                        
                        <span class="badge bg-primary-subtle text-primary fw-semibold mb-4 px-3 py-2">
                            <i class="bi bi-collection me-2"></i>Yarn Collections
                        </span>
                        
                        <h1 class="display-3 fw-light mb-4 text-white">
                            Yarn Collections
                            <span class="d-block fw-normal fs-2 mt-2 text-light">Organized by Category & Season</span>
                        </h1>
                        
                        <p class="lead mb-4 text-light opacity-90">
                            Discover our comprehensive range of luxury yarns organized by fibre type and seasonal availability. 
                            From the softest cashmere to the most durable cotton, find the perfect yarn for your next project.
                        </p>
                        
                        <div class="d-flex gap-3 flex-wrap">
                            <a href="#categories" class="btn btn-primary btn-lg px-4 py-3">
                                <i class="bi bi-arrow-down me-2"></i>Browse by Category
                            </a>
                            <a href="#seasons" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-calendar me-2"></i>Browse by Season
                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="collections-hero-image text-center" data-aos="fade-left">
                        <div class="collections-icon-large mb-4">
                            <i class="bi bi-collection display-1 text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="collections-hero-pattern"></div>
    </section>

    <!-- Categories Section -->
    @if($categories->count() > 0)
        <section id="categories" class="py-5 bg-white">
            <div class="text-center mb-5" data-aos="fade-up">
                <h2 class="fw-light display-6 mb-3">Browse by Yarn Category</h2>
                <p class="text-muted lead">Explore our yarns organized by fibre type and application</p>
            </div>
            
            <div class="container">
                <div class="row g-4">
                    @foreach($categories as $index => $category)
                        @if($category->items->count() > 0)
                            <div class="col-12" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                                <div class="category-section mb-5">
                                    <div class="category-header mb-4">
                                        <div class="row align-items-center">
                                            <div class="col-lg-8">
                                                <h3 class="fw-light display-6 mb-3">{{ $category->name }}</h3>
                                                @if($category->description)
                                                    <p class="text-muted lead mb-3">{{ $category->description }}</p>
                                                @endif
                                                <div class="d-flex gap-3 align-items-center">
                                                    <span class="badge bg-primary px-3 py-2">{{ $category->items->count() }} {{ Str::plural('item', $category->items->count()) }}</span>
                                                    @if($category->sort_order > 0)
                                                        <span class="badge bg-secondary-subtle text-secondary px-3 py-2">Priority {{ $category->sort_order }}</span>
                                                    @endif
                                                </div>
                                            </div>
                                            <div class="col-lg-4 text-center">
                                                <div class="category-icon-large">
                                                    <i class="bi bi-palette2 display-1 text-primary"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="row g-4">
                                        @foreach($category->items as $itemIndex => $item)
                                            <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($itemIndex + 1) * 100 }}">
                                                <div class="category-item-card h-100 rounded shadow-sm border-0 overflow-hidden bg-white">
                                                    <div class="item-image position-relative">
                                                        <div class="ratio ratio-4x3">
                                                            @if($item->season && $item->season->image_path)
                                                                <img src="{{ $item->season->image_path }}" class="w-100 h-100 object-fit-cover" alt="{{ $item->name }}">
                                                            @else
                                                                <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                                                                    <i class="bi bi-{{ $item->season && $item->season->half === 'AW' ? 'snow' : 'sun' }} display-4 text-muted"></i>
                                                                </div>
                                                            @endif
                                                        </div>
                                                        @if($item->season)
                                                            <div class="item-season-badge">
                                                                <span class="badge bg-primary">{{ $item->season->code }}</span>
                                                            </div>
                                                        @endif
                                                    </div>
                                                    
                                                    <div class="item-content p-4">
                                                        <h6 class="fw-semibold mb-2">{{ $item->name }}</h6>
                                                        <p class="text-muted small mb-2">{{ $item->category->name }}</p>
                                                        
                                                        @if($item->description)
                                                            <p class="text-muted small mb-3">{{ Str::limit($item->description, 80) }}</p>
                                                        @endif
                                                        
                                                        @if($item->attributes)
                                                            <div class="item-attributes mb-3">
                                                                @foreach($item->attributes as $key => $value)
                                                                    @if(in_array($key, ['weight', 'gauge', 'type']))
                                                                        <span class="badge bg-light text-dark me-1 mb-1">
                                                                            {{ ucfirst($key) }}: {{ $value }}
                                                                        </span>
                                                                    @endif
                                                                @endforeach
                                                            </div>
                                                        @endif
                                                        
                                                        @if($item->colourways && $item->colourways->count() > 0)
                                                            <div class="colourway-preview mb-3">
                                                                <small class="text-muted d-block mb-2">{{ $item->colourways->count() }} {{ Str::plural('colourway', $item->colourways->count()) }} available</small>
                                                                <div class="d-flex gap-1">
                                                                    @foreach($item->colourways->take(5) as $colourway)
                                                                        <div class="colourway-dot" title="{{ $colourway->name }}"></div>
                                                                    @endforeach
                                                                    @if($item->colourways->count() > 5)
                                                                        <small class="text-muted ms-2">+{{ $item->colourways->count() - 5 }} more</small>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        @endif
                                                        
                                                        <div class="d-flex justify-content-between align-items-center">
                                                            <span class="text-primary fw-semibold small">{{ $item->sku }}</span>
                                                            <a href="#" class="btn btn-outline-primary btn-sm">
                                                                <i class="bi bi-arrow-right"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Seasons Overview -->
    @if($activeSeasons->count() > 0)
        <section id="seasons" class="py-5 bg-light">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Browse by Season</h2>
                    <p class="text-muted lead">Each season brings its own unique character and colour palette</p>
                </div>
                
                <div class="row g-4">
                    @foreach($activeSeasons as $index => $season)
                        <div class="col-lg-6" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="season-card h-100 rounded shadow-sm border-0 overflow-hidden">
                                <div class="row g-0 h-100">
                                    <div class="col-md-4">
                                        @if($season->image_path)
                                            <div class="season-image h-100">
                                                <img src="{{ $season->image_path }}" class="w-100 h-100 object-fit-cover" alt="{{ $season->code }} Collection">
                                            </div>
                                        @else
                                            <div class="season-icon text-center h-100 d-flex flex-column align-items-center justify-content-center bg-light">
                                                <div class="season-icon-circle mb-3">
                                                    <i class="bi bi-{{ $season->half === 'AW' ? 'snow' : 'sun' }} display-4 text-primary"></i>
                                                </div>
                                                <h5 class="fw-semibold text-primary">{{ $season->code }}</h5>
                                                <small class="text-muted">{{ $season->label }}</small>
                                            </div>
                                        @endif
                                    </div>
                                    <div class="col-md-8 p-4">
                                        <h4 class="fw-semibold mb-3">{{ $season->code }} Collection</h4>
                                        <p class="text-muted mb-3">
                                            {{ $season->description }}
                                        </p>
                                        @if($season->starts_on && $season->ends_on)
                                            <p class="text-muted small mb-3">
                                                <i class="bi bi-calendar-event me-2"></i>
                                                Available: {{ \Carbon\Carbon::parse($season->starts_on)->format('M Y') }} - {{ \Carbon\Carbon::parse($season->ends_on)->format('M Y') }}
                                            </p>
                                        @endif
                                        <a href="{{ route('collection.detail', $season->code) }}" class="btn btn-primary">
                                            <i class="bi bi-arrow-right me-2"></i>Explore {{ $season->code }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Featured Items -->
    @if($latestItems->count() > 0)
        <section class="py-5 bg-white">
            <div class="container">
                <div class="text-center mb-5" data-aos="fade-up">
                    <h2 class="fw-light display-6 mb-3">Latest Additions</h2>
                    <p class="text-muted lead">Discover our newest yarn arrivals and most popular selections</p>
                </div>
                
                <div class="row g-4">
                    @foreach($latestItems as $index => $item)
                        <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="{{ ($index + 1) * 100 }}">
                            <div class="item-card h-100 rounded shadow-sm border-0 overflow-hidden">
                                <div class="item-image position-relative">
                                    <div class="ratio ratio-4x3">
                                        @if($item->season && $item->season->image_path)
                                            <img src="{{ $item->season->image_path }}" class="w-100 h-100 object-fit-cover" alt="{{ $item->name }}">
                                        @else
                                            <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                                                <i class="bi bi-{{ $item->season && $item->season->half === 'AW' ? 'snow' : 'sun' }} display-4 text-muted"></i>
                                            </div>
                                        @endif
                                    </div>
                                    @if($item->season)
                                        <div class="item-season-badge">
                                            <span class="badge bg-primary">{{ $item->season->code }}</span>
                                        </div>
                                    @endif
                                </div>
                                <div class="item-content p-4">
                                    <h6 class="fw-semibold mb-2">{{ $item->name }}</h6>
                                    @if($item->category)
                                        <p class="text-muted small mb-2">{{ $item->category->name }}</p>
                                    @endif
                                    @if($item->description)
                                        <p class="text-muted small mb-3">{{ Str::limit($item->description, 80) }}</p>
                                    @endif
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-primary fw-semibold">View Details</span>
                                        <a href="#" class="btn btn-outline-primary btn-sm">
                                            <i class="bi bi-arrow-right"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>
    @endif

    <!-- Call to Action -->
    <section class="py-5 bg-primary text-white">
        <div class="container">
            <div class="row justify-content-center text-center">
                <div class="col-lg-8">
                    <div class="cta-content" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-4">Ready to Start Your Project?</h2>
                        <p class="lead mb-4 opacity-90">
                            Browse our comprehensive yarn collection organized by category and season to find the perfect materials for your next creation.
                        </p>
                        <div class="d-flex gap-3 justify-content-center flex-wrap">
                            <a href="/" class="btn btn-light btn-lg px-4 py-3">
                                <i class="bi bi-house me-2"></i>Back to Home
                            </a>
                            <a href="#categories" class="btn btn-outline-light btn-lg px-4 py-3">
                                <i class="bi bi-arrow-up me-2"></i>Browse Categories
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Newsletter Section -->
    <section id="newsletter" class="py-5 bg-dark text-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="text-center mb-5" data-aos="fade-up">
                        <h2 class="fw-light display-6 mb-3">Stay Connected</h2>
                        <p class="text-light opacity-90 lead">Be the first to know about new collections, exclusive releases, and expert yarn insights.</p>
                    </div>
                    <div class="card border-0 bg-transparent" data-aos="fade-up" data-aos-delay="200">
                        <div class="card-body p-0">
                            <livewire:subscribe-newsletter />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</x-app-layout>
