<?php

use Illuminate\Support\Facades\Route;

Route::middleware('throttle:120,1')->prefix('v1')->group(function () {
    // Health endpoints
    Route::get('/healthz', fn () => response()->json(['status' => 'ok']))->name('healthz');
    Route::get('/readyz', function () {
        try {
            \DB::select('SELECT 1');
            app('redis')->connection()->ping();
            return response()->json(['status' => 'ready']);
        } catch (\Throwable $e) {
            return response()->json(['status' => 'not_ready'], 503);
        }
    })->name('readyz');

    // Auth
    Route::post('/auth/apple', [\App\Http\Controllers\AuthController::class, 'apple']);
    Route::post('/auth/refresh', [\App\Http\Controllers\AuthController::class, 'refresh'])->middleware('auth:sanctum');

    // Me
    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/me', [\App\Http\Controllers\MeController::class, 'show']);
        Route::patch('/me', [\App\Http\Controllers\MeController::class, 'update']);
        Route::delete('/me', [\App\Http\Controllers\MeController::class, 'destroy']);

        Route::get('/profile', [\App\Http\Controllers\ProfileController::class, 'show']);
        Route::patch('/profile', [\App\Http\Controllers\ProfileController::class, 'update']);
        Route::post('/consents', [\App\Http\Controllers\ConsentController::class, 'store']);

        Route::get('/library/categories', [\App\Http\Controllers\LibraryController::class, 'categories']);
        Route::get('/library/tracks', [\App\Http\Controllers\LibraryController::class, 'index']);
        Route::get('/library/tracks/{id}', [\App\Http\Controllers\LibraryController::class, 'show']);

        Route::post('/custom/requests', [\App\Http\Controllers\CustomController::class, 'store']);
        Route::get('/custom/requests/{id}', [\App\Http\Controllers\CustomController::class, 'showRequest']);
        Route::get('/custom/sessions', [\App\Http\Controllers\CustomController::class, 'sessions']);
        Route::get('/custom/sessions/{id}', [\App\Http\Controllers\CustomController::class, 'showSession']);

        Route::post('/iap/verify', [\App\Http\Controllers\IAPController::class, 'verify']);
        Route::get('/entitlements', [\App\Http\Controllers\IAPController::class, 'entitlements']);
    });

    Route::post('/webhooks/apple', [\App\Http\Controllers\IAPController::class, 'webhook']);

    // Admin minimal
    Route::middleware('auth:sanctum')->prefix('admin')->group(function () {
        Route::post('/library/tracks', [\App\Http\Controllers\Admin\LibraryAdminController::class, 'store']);
        Route::patch('/library/tracks/{id}', [\App\Http\Controllers\Admin\LibraryAdminController::class, 'update']);
        Route::delete('/library/tracks/{id}', [\App\Http\Controllers\Admin\LibraryAdminController::class, 'destroy']);
    });
});


