<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\SessionController;
use App\Http\Controllers\Api\MeditationController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\AnalyticsController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Public routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::post('/reset-password', [AuthController::class, 'resetPassword']);

// Health check
Route::get('/health', function () {
    return response()->json([
        'status' => 'healthy',
        'timestamp' => now(),
        'version' => '1.0.0'
    ]);
});

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    // User management
    Route::get('/user', [UserController::class, 'profile']);
    Route::put('/user', [UserController::class, 'updateProfile']);
    Route::delete('/user', [UserController::class, 'deleteAccount']);
    
    // Logout
    Route::post('/logout', [AuthController::class, 'logout']);
    
    // Hypnosis Sessions
    Route::prefix('sessions')->group(function () {
        Route::get('/', [SessionController::class, 'index']);
        Route::post('/', [SessionController::class, 'store']);
        Route::get('/{session}', [SessionController::class, 'show']);
        Route::put('/{session}', [SessionController::class, 'update']);
        Route::delete('/{session}', [SessionController::class, 'destroy']);
        Route::post('/{session}/start', [SessionController::class, 'startSession']);
        Route::post('/{session}/complete', [SessionController::class, 'completeSession']);
        Route::get('/{session}/progress', [SessionController::class, 'getProgress']);
    });
    
    // Meditations
    Route::prefix('meditations')->group(function () {
        Route::get('/', [MeditationController::class, 'index']);
        Route::post('/', [MeditationController::class, 'store']);
        Route::get('/{meditation}', [MeditationController::class, 'show']);
        Route::put('/{meditation}', [MeditationController::class, 'update']);
        Route::delete('/{meditation}', [MeditationController::class, 'destroy']);
        Route::post('/{meditation}/start', [MeditationController::class, 'startMeditation']);
        Route::post('/{meditation}/complete', [MeditationController::class, 'completeMeditation']);
    });
    
    // Analytics
    Route::prefix('analytics')->group(function () {
        Route::get('/overview', [AnalyticsController::class, 'overview']);
        Route::get('/sessions', [AnalyticsController::class, 'sessions']);
        Route::get('/meditations', [AnalyticsController::class, 'meditations']);
        Route::get('/progress', [AnalyticsController::class, 'progress']);
        Route::get('/mood-tracking', [AnalyticsController::class, 'moodTracking']);
    });
});

// Admin routes (if needed)
Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::prefix('admin')->group(function () {
        Route::get('/users', [UserController::class, 'adminIndex']);
        Route::get('/analytics', [AnalyticsController::class, 'adminAnalytics']);
    });
});
