<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class StatementLine extends Model
{
    use HasFactory;

    protected $fillable = [
        'statement_id',
        'transaction_date',
        'posted_date',
        'transaction_time',
        'merchant_name',
        'amount',
        'currency',
        'original_amount',
        'original_currency',
        'conversion_rate',
        'authorisation_code',
        'transaction_id_ext',
        'merchant_category',
        'transaction_type',
        'mcc_description',
        'merchant_city',
        'merchant_state',
        'merchant_postcode',
        'mcc',
        'notes',
    ];

    protected $casts = [
        'transaction_date' => 'date',
        'posted_date' => 'date',
        'amount' => 'decimal:2',
        'original_amount' => 'decimal:2',
        'conversion_rate' => 'decimal:6',
    ];

    public function statement(): BelongsTo
    {
        return $this->belongsTo(Statement::class);
    }
}
