<div>
    <style>
        .cursor-pointer {
            cursor: pointer;
        }
        .cursor-pointer:hover {
            background-color: var(--bs-gray-50);
        }
        .avatar-sm {
            width: 40px;
            height: 40px;
            font-size: 14px;
            font-weight: 600;
        }
        .table tbody tr:hover {
            background-color: var(--bs-gray-50);
        }
        [data-bs-theme="dark"] .table tbody tr:hover {
            background-color: var(--bs-gray-800);
        }
        [data-bs-theme="dark"] .cursor-pointer:hover {
            background-color: var(--bs-gray-800);
        }
    </style>
    
    <!-- Test Content -->
    <div class="alert alert-info">
        <h4>Customers Component Loaded!</h4>
        <p>This is a test to see if the component is rendering.</p>
        <p>Customers found: {{ $customers->count() }}</p>
    </div>
    
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-1">Customers</h1>
            <p class="text-muted mb-0">Manage customer accounts and information</p>
        </div>
        <button class="btn btn-primary">
            <i class="bi bi-person-plus me-2"></i>
            Add Customer
        </button>
    </div>

    <!-- Search and Filters -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-6">
                    <label for="search" class="form-label">Search Customers</label>
                    <input type="text" 
                           id="search"
                           wire:model.live="search" 
                           placeholder="Search by name, email..."
                           class="form-control">
                </div>
                <div class="col-md-3">
                    <label for="perPage" class="form-label">Per Page</label>
                    <select wire:model.live="perPage" class="form-select" id="perPage">
                        <option value="10">10</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                        <option value="100">100</option>
                    </select>
                </div>
                <div class="col-md-3 d-flex align-items-end">
                    <div class="text-muted small">
                        Showing {{ $customers->firstItem() ?? 0 }} to {{ $customers->lastItem() ?? 0 }} 
                        of {{ $customers->total() }} customers
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Customers Table -->
    <div class="card">
        <div class="card-body p-0">
            @if($customers->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Name</th>
                                <th class="border-0">Email</th>
                                <th class="border-0">Role</th>
                                <th class="border-0">Joined</th>
                                <th class="border-0">Last Login</th>
                                <th class="border-0 text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($customers as $customer)
                                <tr class="cursor-pointer" wire:click="viewCustomer({{ $customer->id }})">
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-sm bg-primary text-white rounded-circle d-flex align-items-center justify-content-center me-3">
                                                {{ strtoupper(substr($customer->name, 0, 1)) }}
                                            </div>
                                            <div>
                                                <div class="fw-semibold">{{ $customer->name }}</div>
                                                <small class="text-muted">ID: {{ $customer->id }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div>{{ $customer->email }}</div>
                                        @if($customer->email_verified_at)
                                            <small class="text-success">
                                                <i class="bi bi-check-circle-fill me-1"></i>Verified
                                            </small>
                                        @else
                                            <small class="text-warning">
                                                <i class="bi bi-exclamation-circle-fill me-1"></i>Unverified
                                            </small>
                                        @endif
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ ucfirst($customer->role) }}</span>
                                    </td>
                                    <td>
                                        <div>{{ $customer->created_at->format('M j, Y') }}</div>
                                        <small class="text-muted">{{ $customer->created_at->diffForHumans() }}</small>
                                    </td>
                                    <td>
                                        @if($customer->last_login_at ?? false)
                                            <div>{{ $customer->last_login_at->format('M j, Y') }}</div>
                                            <small class="text-muted">{{ $customer->last_login_at->diffForHumans() }}</small>
                                        @else
                                            <span class="text-muted">Never</span>
                                        @endif
                                    </td>
                                    <td class="text-end">
                                        <div class="btn-group btn-group-sm" role="group">
                                            <button type="button" 
                                                    class="btn btn-outline-primary"
                                                    wire:click.stop="viewCustomer({{ $customer->id }})"
                                                    title="View Customer">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button type="button" 
                                                    class="btn btn-outline-secondary"
                                                    title="Edit Customer">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                
                <!-- Pagination -->
                @if($customers->hasPages())
                    <div class="card-footer">
                        {{ $customers->links() }}
                    </div>
                @endif
            @else
                <!-- Empty State -->
                <div class="text-center py-5">
                    <i class="bi bi-people display-1 text-muted"></i>
                    <h4 class="mt-3">No customers found</h4>
                    <p class="text-muted">
                        @if($search)
                            No customers match your search criteria. Try adjusting your search terms.
                        @else
                            Get started by adding your first customer or importing customer data.
                        @endif
                    </p>
                    @if($search)
                        <button wire:click="$set('search', '')" class="btn btn-outline-primary">
                            Clear Search
                        </button>
                    @else
                        <button class="btn btn-primary">
                            <i class="bi bi-person-plus me-2"></i>
                            Add Customer
                        </button>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>