<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('library_tracks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('category_id')->constrained('library_categories')->onDelete('cascade');
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('description')->nullable();
            $table->text('transcript')->nullable();
            $table->string('duration')->nullable(); // in seconds
            $table->string('file_path')->nullable(); // storage path
            $table->string('file_size')->nullable(); // in bytes
            $table->string('voice_type')->default('neutral'); // male, female, neutral
            $table->string('difficulty_level')->default('beginner'); // beginner, intermediate, advanced
            $table->json('tags')->nullable(); // array of tags
            $table->json('safety_notes')->nullable(); // safety considerations
            $table->boolean('is_active')->default(true);
            $table->integer('play_count')->default(0);
            $table->decimal('rating', 3, 2)->default(0.00); // 0.00 to 5.00
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('library_tracks');
    }
};
