<div x-data="{ openReceiptId: $wire.entangle('selectedReceiptId') }">
    <!-- Flash Messages -->
    @if (session('status'))
        <div class="mb-4 p-4 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-700 rounded-xl">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <p class="text-sm text-green-800 dark:text-green-200">{{ session('status') }}</p>
            </div>
        </div>
    @endif

    @if (session('error'))
        <div class="mb-4 p-4 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-700 rounded-xl">
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
                <p class="text-sm text-red-800 dark:text-red-200">{{ session('error') }}</p>
            </div>
        </div>
    @endif

    <!-- Header -->
    <div class="mb-6 p-6 bg-gradient-to-br from-indigo-50 to-indigo-100/50 dark:from-indigo-900/20 dark:to-indigo-800/20 rounded-2xl border border-indigo-200/50 dark:border-indigo-700/50" wire:poll.5s>
        <div class="flex items-center justify-between gap-3">
            <div class="p-3 bg-indigo-600 rounded-xl">
                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/>
                </svg>
            </div>
            <div class="flex-1">
                @if($statement)
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        Statement #{{ $statement->id }}
                    </h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        {{ $statement->cardholder_name }} · {{ $statement->period_start?->format('M Y') }}
                    </p>
                @else
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Statement Review</h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400">Select a statement from the Statements tab to review</p>
                @endif
            </div>
            <div class="flex items-center gap-3">
                <div class="text-xs text-gray-700 dark:text-gray-300">
                    Unmatched receipts: <span class="font-semibold">{{ $unmatchedReceiptsCount ?? 0 }}</span>
                    · Unmatched lines: <span class="font-semibold">{{ $unmatchedTransactionsCount ?? 0 }}</span>
                </div>
                <button wire:click="runMatching" wire:loading.attr="disabled" class="inline-flex items-center gap-2 px-4 py-2 rounded-xl bg-gradient-to-r from-indigo-600 to-indigo-700 text-white text-sm font-medium hover:from-indigo-700 hover:to-indigo-800 focus:outline-none focus:ring-2 focus:ring-indigo-500 transition-all">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3a2 2 0 00-2 2v4a2 2 0 002 2h4a2 2 0 002-2V5a2 2 0 00-2-2H5zm10 0h4a2 2 0 012 2v4a2 2 0 01-2 2h-4a2 2 0 01-2-2V5a2 2 0 012-2zm-10 10h4a2 2 0 012 2v4a2 2 0 01-2 2H5a2 2 0 01-2-2v-4a2 2 0 012-2zm10 0h4a2 2 0 012 2v4a2 2 0 01-2 2h-4a2 2 0 01-2-2v-4a2 2 0 012-2z"/></svg>
                    <span wire:loading.remove wire:target="runMatching">Run Matching</span>
                    <span wire:loading wire:target="runMatching" class="inline-flex items-center gap-1">
                        <svg class="animate-spin h-4 w-4" fill="none" viewBox="0 0 24 24"><circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle><path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path></svg>
                        Running...
                    </span>
                </button>
            </div>
        </div>
    </div>

    <!-- Receipts Section -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
        <!-- Unmatched Receipts -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-5 py-4 bg-gradient-to-br from-amber-50 to-amber-100/30 dark:from-amber-900/20 dark:to-amber-800/10 border-b border-amber-200/50 dark:border-amber-700/50">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-2">
                        <div class="p-2 bg-amber-500/20 rounded-lg">
                            <svg class="w-4 h-4 text-amber-600 dark:text-amber-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <div>
                            <div class="text-xs font-semibold uppercase tracking-wide text-amber-900 dark:text-amber-300">Unmatched Receipts</div>
                            <div class="text-xs text-amber-700 dark:text-amber-400">{{ $unmatchedReceiptsCount ?? $unmatchedReceipts->count() }} items</div>
                        </div>
                    </div>
                    
                </div>
            </div>
            <div class="max-h-[500px] overflow-y-auto">
                @forelse ($unmatchedReceipts as $r)
                <div class="px-5 py-4 border-b border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                                <div class="font-medium text-gray-900 dark:text-white mb-1">{{ $r->merchant_name ?? 'Unknown Merchant' }}</div>
                                <div class="flex items-center gap-3 text-xs text-gray-600 dark:text-gray-400">
                                    <span class="flex items-center gap-1">
                                        <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                        {{ $r->receipt_date?->format('d M Y') }}
                                    </span>
                                    <span class="flex items-center gap-1 font-semibold text-amber-700 dark:text-amber-400">
                                        £{{ number_format($r->total_amount,2) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="flex items-center gap-2 ml-3">
                            <button type="button" wire:click.stop="selectReceipt({{ $r->id }})" x-on:click.stop class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded-lg transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </button>
                            <button type="button" wire:click.stop="reprocessReceipt({{ $r->id }})" class="px-2 py-1 text-xs rounded border border-indigo-300 text-indigo-700 hover:bg-indigo-50 dark:border-indigo-600 dark:text-indigo-300 dark:hover:bg-indigo-900/20">
                                AI Read
                            </button>
                            <button type="button" wire:click.stop="matchReceipt({{ $r->id }})" wire:loading.attr="disabled" class="px-2 py-1 text-xs rounded border border-green-300 text-green-700 hover:bg-green-50 dark:border-green-600 dark:text-green-300 dark:hover:bg-green-900/20">
                                <span wire:loading.remove wire:target="matchReceipt">AI Match</span>
                                <span wire:loading wire:target="matchReceipt">Matching...</span>
                            </button>
                            <button type="button" wire:click.stop="openManualMatchModal({{ $r->id }})" class="px-2 py-1 text-xs rounded border border-purple-300 text-purple-700 hover:bg-purple-50 dark:border-purple-600 dark:text-purple-300 dark:hover:bg-purple-900/20">
                                Match
                            </button>
                        </div>
                    </div>
                </div>
                @empty
                <div class="px-5 py-12 text-center">
                    <div class="w-12 h-12 mx-auto mb-3 p-3 bg-gray-100 dark:bg-gray-700 rounded-full">
                        <svg class="w-full h-full text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/></svg>
                    </div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">All receipts matched</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Matched Receipts -->
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-5 py-4 bg-gradient-to-br from-green-50 to-green-100/30 dark:from-green-900/20 dark:to-green-800/10 border-b border-green-200/50 dark:border-green-700/50">
                <div class="flex items-center gap-2">
                    <div class="p-2 bg-green-500/20 rounded-lg">
                        <svg class="w-4 h-4 text-green-600 dark:text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <div>
                        <div class="text-xs font-semibold uppercase tracking-wide text-green-900 dark:text-green-300">Matched Receipts</div>
                        <div class="text-xs text-green-700 dark:text-green-400">{{ $matchedReceipts->count() }} items</div>
                    </div>
                </div>
            </div>
            <div class="max-h-[500px] overflow-y-auto">
                @forelse ($matchedReceipts as $r)
                <div class="px-5 py-4 border-b border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700/50 transition-colors">
                    <div class="flex items-center justify-between">
                        <div class="flex-1">
                            <div class="flex items-center gap-2 mb-1">
                                <div class="font-medium text-gray-900 dark:text-white">{{ $r->merchant_name ?? 'Unknown Merchant' }}</div>
                                @if($r->matches->count() > 0)
                                    @php
                                        $match = $r->matches->first();
                                        $transaction = $match->statementTransaction;
                                        $totalReceiptsForTransaction = $transaction->matches->count();
                                    @endphp
                                    @if($totalReceiptsForTransaction > 1)
                                        <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300">
                                            <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"/>
                                            </svg>
                                            Grouped ({{ $totalReceiptsForTransaction }})
                                        </span>
                                    @endif
                                @endif
                            </div>
                            <div class="flex items-center gap-3 text-xs text-gray-600 dark:text-gray-400">
                                <span class="flex items-center gap-1">
                                    <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"/></svg>
                                    {{ $r->receipt_date?->format('d M Y') }}
                                </span>
                                <span class="flex items-center gap-1 font-semibold text-green-700 dark:text-green-400">
                                    £{{ number_format($r->total_amount,2) }}
                                </span>
                                @if($r->matches->count() > 0)
                                    @php
                                        $match = $r->matches->first();
                                        $transaction = $match->statementTransaction;
                                    @endphp
                                    <span class="text-xs text-gray-500 dark:text-gray-400">
                                        → {{ $transaction->merchant_name }} (£{{ number_format($transaction->amount, 2) }})
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="flex items-center gap-2 ml-3">
                            <button type="button" wire:click.stop="selectReceipt({{ $r->id }})" x-on:click.stop class="p-2 text-gray-400 hover:text-blue-600 hover:bg-blue-50 dark:hover:bg-blue-900/20 rounded-lg transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </button>
                            <button type="button" 
                                    wire:click.stop="unmatchReceipt({{ $r->id }})" 
                                    wire:confirm="Are you sure you want to unmatch this receipt? This action cannot be undone."
                                    wire:loading.attr="disabled"
                                    class="p-2 text-gray-400 hover:text-red-600 hover:bg-red-50 dark:hover:bg-red-900/20 rounded-lg transition-colors"
                                    title="Unmatch receipt">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                </div>
                @empty
                <div class="px-5 py-12 text-center">
                    <div class="w-12 h-12 mx-auto mb-3 p-3 bg-gray-100 dark:bg-gray-700 rounded-full">
                        <svg class="w-full h-full text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/></svg>
                    </div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">No matches yet</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- All Lines Section -->
        <div class="col-span-2 lg:col-span-2 bg-white dark:bg-gray-800 rounded-2xl shadow-sm border border-gray-100 dark:border-gray-700 overflow-hidden">
            <div class="px-5 py-4 bg-gradient-to-br from-blue-50 to-blue-100/30 dark:from-blue-900/20 dark:to-blue-800/10 border-b border-blue-200/50 dark:border-blue-700/50">
                <div class="flex items-center gap-2">
                    <div class="p-2 bg-blue-500/20 rounded-lg">
                        <svg class="w-4 h-4 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/>
                        </svg>
                    </div>
                    <div>
                        <div class="text-xs font-semibold uppercase tracking-wide text-blue-900 dark:text-blue-300">All Receipt Lines</div>
                        <div class="text-xs text-blue-700 dark:text-blue-400">{{ $allTransactions->count() }} items</div>
                    </div>
                </div>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 dark:bg-gray-700">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Status</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Merchant</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">GBP Amount</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Original Amount (Abroad)</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Location</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Department</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Purpose (Account)</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider">Date</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                        @forelse($allTransactions as $transaction)
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700/50">
                            <td class="px-4 py-3 whitespace-nowrap">
                                @if($transaction->matches->count() > 0)
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300">
                                        <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                        </svg>
                                        Matched
                                    </span>
                                @else
                                    <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-900/30 dark:text-orange-300">
                                        <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v3m0 0v3m0-3h3m-3 0H9m12 0a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                        </svg>
                                        Unmatched
                                    </span>
                                @endif
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                {{ $transaction->merchant_name ?? 'Unknown' }}
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-900 dark:text-white">
                                £{{ number_format($transaction->amount, 2) }}
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                @if($transaction->original_amount && $transaction->original_currency && $transaction->original_currency !== 'GBP')
                                    <span class="font-mono">{{ number_format($transaction->original_amount, 2) }}</span>
                                    <span class="text-xs ml-1">{{ $transaction->original_currency }}</span>
                                @else
                                    <span class="text-gray-400 dark:text-gray-500">—</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 text-sm text-gray-500 dark:text-gray-400">
                                @if($transaction->merchant_postcode || $transaction->merchant_city || $transaction->merchant_state)
                                    @php
                                        $locationParts = array_filter([
                                            $transaction->merchant_postcode,
                                            $transaction->merchant_city,
                                            $transaction->merchant_state
                                        ]);
                                    @endphp
                                    {{ implode(', ', $locationParts) }}
                                @else
                                    <span class="text-gray-400 dark:text-gray-500">—</span>
                                @endif
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <select wire:model.live="transactions.{{ $transaction->id }}.department_id" 
                                        class="text-xs border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white w-28">
                                    <option value="">—</option>
                                    @foreach($departments as $dept)
                                        <option value="{{ $dept->id }}" {{ $transaction->department_id == $dept->id ? 'selected' : '' }}>{{ strtoupper($dept->code ?? Str::substr($dept->name,0,2)) }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap">
                                <select wire:model.live="transactions.{{ $transaction->id }}.account_id" 
                                        class="text-sm border-gray-300 dark:border-gray-600 rounded-md shadow-sm focus:border-indigo-500 focus:ring-indigo-500 dark:bg-gray-700 dark:text-white">
                                    <option value="">Select Account</option>
                                    @foreach($accounts as $account)
                                        <option value="{{ $account->id }}" {{ $transaction->account_id == $account->id ? 'selected' : '' }}>
                                            {{ $account->name }} ({{ $account->code }})
                                        </option>
                                    @endforeach
                                </select>
                            </td>
                            <td class="px-4 py-3 whitespace-nowrap text-sm text-gray-500 dark:text-gray-400">
                                <div class="flex items-center justify-between gap-3">
                                    <span>{{ $transaction->transaction_date?->format('M j, Y') ?? '—' }}</span>
                                    <button type="button" class="text-xs inline-flex items-center px-2 py-1 rounded border border-gray-300 dark:border-gray-600 hover:bg-gray-100 dark:hover:bg-gray-700"
                                            wire:click="toggleExpand({{ $transaction->id }})">
                                        Split
                                    </button>
                                </div>
                            </td>
                            
                        </tr>
                        @php
                            $txnId = $transaction->id;
                            $hasSplits = !empty($splits[$txnId] ?? []);
                        @endphp
                        @if(($expanded[$txnId] ?? false))
                        <tr class="bg-gray-50/50 dark:bg-gray-800/40" x-data="{ open: $wire.entangle('expanded.{{ $transaction->id }}') }">
                            <td colspan="8" class="px-4 py-2">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center gap-2">
                                        <button type="button" class="text-xs inline-flex items-center px-2 py-1 rounded border border-blue-300 dark:border-blue-600 text-blue-700 dark:text-blue-400 hover:bg-blue-50 dark:hover:bg-blue-900/20"
                                                wire:click="applyReceiptSplits({{ $transaction->id }})"
                                                wire:loading.attr="disabled"
                                                wire:loading.class="opacity-50 cursor-not-allowed">
                                            <span wire:loading.remove wire:target="applyReceiptSplits">Use receipt lines</span>
                                            <span wire:loading wire:target="applyReceiptSplits">Processing...</span>
                                        </button>
                                        <button type="button" class="text-xs inline-flex items-center px-2 py-1 rounded border border-gray-300 hover:bg-gray-50"
                                                wire:click="addSplit({{ $transaction->id }})">
                                            Add split
                                        </button>
                                        @if($hasSplits)
                                        <button type="button" class="text-xs inline-flex items-center px-2 py-1 rounded border border-red-300 text-red-700 hover:bg-red-50"
                                                wire:click="clearSplits({{ $transaction->id }})">
                                            Clear splits
                                        </button>
                                        @endif
                                    </div>
                                    @if($hasSplits)
                                    <div class="text-xs text-gray-500">{{ count($splits[$txnId]) }} split(s)</div>
                                    @endif
                                </div>
                                <div x-show="open" class="mt-3">
                                    <div class="overflow-x-auto">
                                        <table class="w-full text-xs">
                                            <thead class="bg-gray-100 dark:bg-gray-700">
                                                <tr>
                                                    <th class="px-3 py-2 text-left">Department</th>
                                                    <th class="px-3 py-2 text-left">Account</th>
                                                    <th class="px-3 py-2 text-left">Amount</th>
                                                    <th class="px-3 py-2 text-left">Description</th>
                                                    <th class="px-3 py-2"></th>
                                                </tr>
                                            </thead>
                                            <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                                                @forelse(($splits[$txnId] ?? []) as $idx => $split)
                                                <tr>
                                                    <td class="px-3 py-2">
                                                        <select wire:model.live="splits.{{ $transaction->id }}.{{ $idx }}.department_id" class="w-28 text-xs border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                                                            <option value="">—</option>
                                                            @foreach($departments as $dept)
                                                                <option value="{{ $dept->id }}">{{ strtoupper($dept->code ?? Str::substr($dept->name,0,2)) }}</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="px-3 py-2">
                                                        <select wire:model.live="splits.{{ $transaction->id }}.{{ $idx }}.account_id" class="min-w-[10rem] text-xs border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white">
                                                            <option value="">Select Account</option>
                                                            @foreach($accounts as $account)
                                                                <option value="{{ $account->id }}">{{ $account->name }} ({{ $account->code }})</option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td class="px-3 py-2">
                                                        <input type="number" step="0.01" wire:model.live="splits.{{ $transaction->id }}.{{ $idx }}.amount" class="w-28 text-xs border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white" placeholder="0.00" />
                                                    </td>
                                                    <td class="px-3 py-2">
                                                        <input type="text" wire:model.live="splits.{{ $transaction->id }}.{{ $idx }}.description" class="w-full text-xs border-gray-300 dark:border-gray-600 rounded-md dark:bg-gray-700 dark:text-white" placeholder="Optional note" />
                                                    </td>
                                                    <td class="px-3 py-2 text-right">
                                                        <button type="button" class="text-xs text-red-600 hover:underline" wire:click="removeSplit({{ $transaction->id }}, {{ $idx }})">Remove</button>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="5" class="px-3 py-4 text-gray-500">No splits yet. Add one or use receipt lines.</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @endif
                        @empty
                        <tr>
                            <td colspan="8" class="px-4 py-8 text-center text-gray-500 dark:text-gray-400">
                                <svg class="w-8 h-8 mx-auto mb-2 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                </svg>
                                <p>No transactions found</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Receipt Details Modal -->
    <div x-cloak x-show="openReceiptId" class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50" @click="openReceiptId = null; $wire.closeModal()">
    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-xl max-w-2xl w-full mx-4 max-h-[90vh] overflow-hidden" @click.stop>
        <div class="flex items-center justify-between p-6 border-b border-gray-200 dark:border-gray-700">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Receipt Details</h3>
            <button type="button" @click="openReceiptId = null; $wire.closeModal()" class="p-2 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                </svg>
            </button>
        </div>
        
        <div class="p-6 overflow-y-auto max-h-[calc(90vh-120px)]">
            @if($selectedReceipt)
                        <!-- Receipt Header -->
                        <div class="bg-gradient-to-br from-blue-50 to-indigo-50 dark:from-blue-900/20 dark:to-indigo-900/20 rounded-xl p-6 mb-6 border border-blue-200/50 dark:border-blue-700/50">
                            <div class="flex items-center justify-between mb-4">
                                <div>
                                    <h4 class="text-xl font-bold text-gray-900 dark:text-white">{{ $selectedReceipt->merchant_name ?? 'Unknown Merchant' }}</h4>
                                    <p class="text-sm text-gray-600 dark:text-gray-400">{{ $selectedReceipt->receipt_date?->format('l, F j, Y') }}</p>
                                </div>
                                <div class="text-right">
                                    <div class="text-2xl font-bold text-blue-600 dark:text-blue-400">
                                        £<input type="number" step="0.01" class="w-28 inline-block text-right bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-600 rounded px-1 focus:outline-none focus:ring-1 focus:ring-blue-500" wire:model.lazy="editReceipt.total_amount" />
                                    </div>
                                    <div class="text-sm text-gray-500 dark:text-gray-400">{{ $selectedReceipt->currency }}</div>
                                </div>
                            </div>
                            
                        </div>


                <!-- Business Information -->
                @if($selectedReceipt->meta)
                    @php $meta = is_string($selectedReceipt->meta) ? json_decode($selectedReceipt->meta, true) : $selectedReceipt->meta; @endphp
                    
                    @if(!empty($meta['store_location']) || !empty($meta['phone_number']) || !empty($meta['email']))
                    <div class="bg-gray-50 dark:bg-gray-700/50 rounded-xl p-4 mb-6">
                        <h5 class="font-semibold text-gray-900 dark:text-white mb-3 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            Business Information
                        </h5>
                        <div class="space-y-2 text-sm">
                            @if(!empty($meta['store_location']))
                                <div class="flex items-start gap-2">
                                    <svg class="w-4 h-4 mt-0.5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    </svg>
                                    <span class="text-gray-700 dark:text-gray-300">{{ $meta['store_location'] }}</span>
                                </div>
                            @endif
                            @if(!empty($meta['phone_number']))
                                <div class="flex items-center gap-2">
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                    </svg>
                                    <a href="tel:{{ $meta['phone_number'] }}" class="text-blue-600 dark:text-blue-400 hover:underline">{{ $meta['phone_number'] }}</a>
                                </div>
                            @endif
                            @if(!empty($meta['email']))
                                <div class="flex items-center gap-2">
                                    <svg class="w-4 h-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 4.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"/>
                                    </svg>
                                    <a href="mailto:{{ $meta['email'] }}" class="text-blue-600 dark:text-blue-400 hover:underline">{{ $meta['email'] }}</a>
                                </div>
                            @endif
                        </div>
                    </div>
                    @endif

                    <!-- Transaction Details -->
                    @if(!empty($meta['receipt_number']) || !empty($meta['transaction_id']) || !empty($meta['payment_method']))
                    <div class="bg-gray-50 dark:bg-gray-700/50 rounded-xl p-4 mb-6">
                        <h5 class="font-semibold text-gray-900 dark:text-white mb-3 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            Transaction Details
                        </h5>
                        <div class="grid grid-cols-2 gap-4 text-sm">
                            @if(!empty($meta['receipt_number']))
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Receipt #:</span>
                                    <span class="ml-2 font-mono text-gray-900 dark:text-white">{{ $meta['receipt_number'] }}</span>
                                </div>
                            @endif
                            @if(!empty($meta['transaction_id']))
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Transaction ID:</span>
                                    <span class="ml-2 font-mono text-gray-900 dark:text-white">{{ $meta['transaction_id'] }}</span>
                                </div>
                            @endif
                            @if(!empty($meta['payment_method']))
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Payment Method:</span>
                                    <span class="ml-2 text-gray-900 dark:text-white">{{ $meta['payment_method'] }}</span>
                                </div>
                            @endif
                            @if(!empty($meta['cashier_name']))
                                <div>
                                    <span class="text-gray-500 dark:text-gray-400">Cashier:</span>
                                    <span class="ml-2 text-gray-900 dark:text-white">{{ $meta['cashier_name'] }}</span>
                                </div>
                            @endif
                        </div>
                    </div>
                    @endif
                @endif

                <!-- Line Items -->
                @php
                    $__lines = $editReceipt['lines'] ?? [];
                @endphp
                @if($__lines && count($__lines) > 0)
                <div class="bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-xl overflow-hidden mb-6">
                    <div class="bg-gray-50 dark:bg-gray-700 px-4 py-3 border-b border-gray-200 dark:border-gray-700">
                        <h5 class="font-semibold text-gray-900 dark:text-white flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-6 9l2 2 4-4"/>
                            </svg>
                            Items ({{ count($__lines) }})
                        </h5>
                    </div>
                    <div class="divide-y divide-gray-200 dark:divide-gray-700">
                        @foreach($__lines as $idx => $line)
                        <div class="p-4">
                            <div class="flex justify-between items-start mb-2">
                                <div class="flex-1">
                                    <h6 class="font-medium text-gray-900 dark:text-white">{{ $line['description'] }}</h6>
                                </div>
                                <div class="text-right ml-4">
                                    <div class="font-semibold text-gray-900 dark:text-white">
                                        £<input type="number" step="0.01" class="w-24 inline-block text-right bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-600 rounded px-1 focus:outline-none focus:ring-1 focus:ring-blue-500" wire:model.live="editReceipt.lines.{{ $idx }}.line_total" />
                                    </div>
                                    @if(($line['quantity'] ?? 1) > 1)
                                    <div class="text-xs text-gray-500 dark:text-gray-400">
                                        {{ $line['quantity'] }} × £<input type="number" step="0.01" class="w-16 inline-block text-right bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-600 rounded px-1 focus:outline-none focus:ring-1 focus:ring-blue-500" wire:model.lazy="editReceipt.lines.{{ $idx }}.unit_price" />
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                    @php
                        $__sum = 0.0; foreach($__lines as $__l){ $__sum += (float) ($__l['line_total'] ?? 0); }
                        $__sum = number_format($__sum, 2, '.', '');
                        $__total = number_format((float) ($editReceipt['total_amount'] ?? 0), 2, '.', '');
                    @endphp
                    <div class="px-4 py-3 bg-gray-50 dark:bg-gray-700 flex items-center justify-between text-sm">
                        <span class="text-gray-600 dark:text-gray-300">Lines total</span>
                        <span class="font-semibold {{ $__sum === $__total ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">£{{ number_format($__sum, 2) }} / £{{ number_format($__total, 2) }}</span>
                    </div>
                </div>
                @endif

                <!-- Additional Information -->
                @if($selectedReceipt->meta)
                    @php $meta = is_string($selectedReceipt->meta) ? json_decode($selectedReceipt->meta, true) : $selectedReceipt->meta; @endphp
                    
                    @if(!empty($meta['additional_notes']))
                    <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-700/50 rounded-xl p-4 mb-6">
                        <h5 class="font-semibold text-amber-900 dark:text-amber-300 mb-2 flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                            </svg>
                            Additional Notes
                        </h5>
                        <p class="text-sm text-amber-800 dark:text-amber-200 whitespace-pre-line">{{ $meta['additional_notes'] }}</p>
                    </div>
                    @endif

                            @if(!empty($meta['return_policy']))
                            <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-700/50 rounded-xl p-4 mb-6">
                                <h5 class="font-semibold text-green-900 dark:text-green-300 mb-2 flex items-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"/>
                                    </svg>
                                    Return Policy
                                </h5>
                                <p class="text-sm text-green-800 dark:text-green-200">{{ $meta['return_policy'] }}</p>
                            </div>
                            @endif

                            <!-- VAT Analysis Section -->
                            @if(!empty($meta['vat_exemption_notes']) || !empty($meta['vat_breakdown']) || !empty($meta['vat_amount']))
                            <div class="bg-gradient-to-br from-green-50 to-emerald-50 dark:from-green-900/20 dark:to-emerald-900/20 border border-green-200 dark:border-green-700/50 rounded-xl p-6">
                                <h5 class="font-semibold text-green-900 dark:text-green-300 mb-4 flex items-center gap-2">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 7h6m0 10v-3m-3 3h.01M9 17h.01M9 14h.01M12 14h.01M15 11h.01M12 11h.01M9 11h.01M7 21h10a2 2 0 002-2V5a2 2 0 00-2-2H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                                    </svg>
                                    VAT Analysis
                                </h5>
                                
                                <!-- VAT Summary -->
                                <div class="bg-white dark:bg-gray-800/50 rounded-lg p-4 border border-green-200/50 dark:border-green-600/50 mb-4">
                                    <h6 class="font-medium text-green-900 dark:text-green-200 mb-3">VAT Summary</h6>
                                    <div class="grid grid-cols-2 gap-4 text-sm">
                                        @if(!empty($meta['subtotal']))
                                        <div>
                                            <span class="text-gray-500 dark:text-gray-400">Subtotal:</span>
                                            <span class="ml-2 font-semibold text-gray-900 dark:text-white">£{{ number_format($meta['subtotal'], 2) }}</span>
                                        </div>
                                        @endif
                                        @if(!empty($meta['vat_amount']))
                                        <div>
                                            <span class="text-gray-500 dark:text-gray-400">VAT Amount:</span>
                                            <span class="ml-2 font-semibold text-green-600 dark:text-green-400">£{{ number_format($meta['vat_amount'], 2) }}</span>
                                        </div>
                                        @endif
                                        @if(!empty($meta['vat_number']))
                                        <div class="col-span-2">
                                            <span class="text-gray-500 dark:text-gray-400">VAT Number:</span>
                                            <span class="ml-2 font-mono text-gray-900 dark:text-white">{{ $meta['vat_number'] }}</span>
                                        </div>
                                        @endif
                                        @if(isset($meta['is_vat_inclusive']))
                                        <div class="col-span-2">
                                            <span class="text-gray-500 dark:text-gray-400">VAT Status:</span>
                                            <span class="ml-2 inline-flex items-center px-2 py-1 rounded-full text-xs font-medium {{ $meta['is_vat_inclusive'] ? 'bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300' : 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300' }}">
                                                {{ $meta['is_vat_inclusive'] ? 'VAT Inclusive' : 'VAT Exclusive' }}
                                            </span>
                                        </div>
                                        @endif
                                        @if(!empty($meta['discount_analysis']['total_discount_amount']))
                                        <div class="col-span-2">
                                            <span class="text-gray-500 dark:text-gray-400">Total Discounts:</span>
                                            <span class="ml-2 font-semibold text-red-600 dark:text-red-400">-£{{ number_format($meta['discount_analysis']['total_discount_amount'], 2) }}</span>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                                
                                @if(!empty($meta['vat_exemption_notes']))
                                <div class="mb-4">
                                    <h6 class="font-medium text-green-800 dark:text-green-200 mb-2">VAT Exemptions & Notes:</h6>
                                    <p class="text-sm text-green-700 dark:text-green-300 bg-green-100 dark:bg-green-900/30 rounded-lg p-3">{{ $meta['vat_exemption_notes'] }}</p>
                                </div>
                                @endif
                                
                                @if(!empty($meta['vat_breakdown']))
                                <div class="mb-4">
                                    <h6 class="font-medium text-green-800 dark:text-green-200 mb-2">VAT Rate Breakdown:</h6>
                                    <div class="grid grid-cols-2 gap-3">
                                        @foreach($meta['vat_breakdown'] as $rate => $amount)
                                        <div class="bg-green-100 dark:bg-green-900/30 rounded-lg p-3">
                                            <div class="text-sm font-medium text-green-900 dark:text-green-200">{{ $rate }}</div>
                                            <div class="text-lg font-bold text-green-700 dark:text-green-300">£{{ number_format($amount, 2) }}</div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                                
                                <div class="text-xs text-green-600 dark:text-green-400 bg-green-50 dark:bg-green-900/20 rounded-lg p-3">
                                    <strong>Ready for VAT Expert Analysis:</strong> This receipt contains comprehensive VAT data for UK VAT compliance review and potential reclaim calculations.
                                </div>
                            </div>
                            @endif

                            <!-- Discount Analysis Section -->
                            @if(!empty($meta['discount_analysis']))
                            <div class="bg-gradient-to-br from-red-50 to-orange-50 dark:from-red-900/20 dark:to-orange-900/20 border border-red-200 dark:border-red-700/50 rounded-xl p-6">
                                <h5 class="font-semibold text-red-900 dark:text-red-300 mb-4 flex items-center gap-2">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                                    </svg>
                                    Discount Analysis
                                </h5>
                                
                                @if(!empty($meta['discount_analysis']['total_discount_amount']))
                                <div class="mb-4">
                                    <h6 class="font-medium text-red-800 dark:text-red-200 mb-2">Total Savings:</h6>
                                    <div class="text-3xl font-bold text-red-600 dark:text-red-400">
                                        -£{{ number_format($meta['discount_analysis']['total_discount_amount'], 2) }}
                                    </div>
                                </div>
                                @endif
                                
                                @if(!empty($meta['discount_analysis']['discount_breakdown']))
                                <div class="mb-4">
                                    <h6 class="font-medium text-red-800 dark:text-red-200 mb-3">Discount Breakdown:</h6>
                                    <div class="space-y-3">
                                        @foreach($meta['discount_analysis']['discount_breakdown'] as $discount)
                                        <div class="bg-red-100 dark:bg-red-900/30 rounded-lg p-4">
                                            <div class="flex justify-between items-start mb-2">
                                                <div>
                                                    <h6 class="font-medium text-red-900 dark:text-red-200">{{ $discount['discount_description'] }}</h6>
                                                    <span class="inline-block px-2 py-1 text-xs bg-red-200 dark:bg-red-800 text-red-800 dark:text-red-200 rounded-full mt-1">
                                                        {{ ucfirst(str_replace('_', ' ', $discount['discount_type'])) }}
                                                    </span>
                                                </div>
                                                <div class="text-right">
                                                    <div class="text-lg font-bold text-red-600 dark:text-red-400">
                                                        -£{{ number_format($discount['discount_amount'], 2) }}
                                                    </div>
                                                </div>
                                            </div>
                                            @if(!empty($discount['applies_to_lines']))
                                            <div class="text-sm text-red-700 dark:text-red-300">
                                                Applied to lines: {{ implode(', ', $discount['applies_to_lines']) }}
                                                @if($discount['vat_affected'])
                                                    <span class="ml-2 inline-block px-1 py-0.5 text-xs bg-yellow-200 dark:bg-yellow-800 text-yellow-800 dark:text-yellow-200 rounded">
                                                        VAT Affected
                                                    </span>
                                                @endif
                                            </div>
                                            @endif
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                                
                                @if(!empty($meta['discount_analysis']['discount_notes']))
                                <div class="text-sm text-red-700 dark:text-red-300 bg-red-100 dark:bg-red-900/30 rounded-lg p-3">
                                    <strong>Notes:</strong> {{ $meta['discount_analysis']['discount_notes'] }}
                                </div>
                                @endif
                                
                                @if(!empty($meta['discount_analysis']['vat_recalculation_needed']) && $meta['discount_analysis']['vat_recalculation_needed'])
                                <div class="text-xs text-amber-600 dark:text-amber-400 bg-amber-50 dark:bg-amber-900/20 rounded-lg p-3 mt-4">
                                    <strong>VAT Recalculation Required:</strong> Discounts have affected VAT calculations. Review VAT amounts for accuracy.
                                </div>
                                @endif
                            </div>
                            @endif

                            <!-- Original Receipt Image -->
                            <div class="bg-gray-50 dark:bg-gray-700/50 rounded-xl p-4 mt-6">
                                <h5 class="font-semibold text-gray-900 dark:text-white mb-3 flex items-center gap-2">
                                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                    </svg>
                                    Original Receipt
                                </h5>
                                
                                <div class="relative">
                                    @if($selectedReceipt->image_path)
                                        @php
                                            $imagePath = Storage::disk($selectedReceipt->image_disk)->path($selectedReceipt->image_path);
                                            $imageData = base64_encode(file_get_contents($imagePath));
                                            $imageUrl = 'data:image/jpeg;base64,' . $imageData;
                                        @endphp
                                        <img src="{{ $imageUrl }}" 
                                             alt="Receipt image" 
                                             class="w-full h-auto rounded-lg border border-gray-200 dark:border-gray-700"
                                             loading="lazy">
                                        
                                        <!-- Image overlay with receipt info -->
                                        <div class="absolute top-3 right-3 bg-black/75 text-white px-2 py-1 rounded text-xs">
                                            <div class="font-medium">{{ $selectedReceipt->merchant_name }}</div>
                                            <div class="opacity-90">{{ $selectedReceipt->receipt_date?->format('M j, Y') }}</div>
                                        </div>
                                    @else
                                        <div class="bg-gray-100 dark:bg-gray-700 rounded-lg p-8 text-center">
                                            <svg class="w-16 h-16 mx-auto mb-4 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                            </svg>
                                            <p class="text-gray-500 dark:text-gray-400">No receipt image available</p>
                                        </div>
                                    @endif
                                </div>
                                
                                @if($selectedReceipt->image_path)
                                <div class="mt-4 text-xs text-gray-500 dark:text-gray-400 flex items-center justify-between">
                                    <span>Receipt ID: {{ $selectedReceipt->id }}</span>
                                    <span>{{ $selectedReceipt->lines->count() }} items extracted</span>
                                </div>
                                @endif
                            </div>
                            <div class="mt-4 flex justify-end gap-2">
                                <button type="button" class="px-3 py-2 text-sm rounded border border-gray-300 hover:bg-gray-50" @click="openReceiptId = null; $wire.closeModal()">Cancel</button>
                                <button type="button" class="px-3 py-2 text-sm rounded bg-indigo-600 text-white hover:bg-indigo-700" wire:click="saveReceiptEdits">Save</button>
                            </div>
                        @endif
            @else
                <div class="text-center py-8">
                    <div class="w-12 h-12 mx-auto mb-3 p-3 bg-gray-100 dark:bg-gray-700 rounded-full">
                        <svg class="w-full h-full text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                        </svg>
                    </div>
                    <p class="text-gray-500 dark:text-gray-400">Receipt not found</p>
                </div>
            @endif
        </div>
    </div>

    <!-- Match Modal -->
    {{-- @if($showManualMatchModal) --}}
    <div class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50" wire:click="closeManualMatchModal">
        <div class="relative top-20 mx-auto p-5 border w-11/12 md:w-2/3 lg:w-1/2 shadow-lg rounded-md bg-white dark:bg-gray-800" wire:click.stop>
            <div class="mt-3">
                <!-- Header -->
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-medium text-gray-900 dark:text-white">Receipt Match</h3>
                    <button wire:click="closeManualMatchModal" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>

            @if($manualMatchReceiptId)
                @php
                    $receipt = \App\Models\Receipt::find($manualMatchReceiptId);
                    $transactions = $this->getAvailableTransactions();
                @endphp
                
                @if($receipt)
                <!-- Receipt Info -->
                <div class="mb-6 p-4 bg-gray-50 dark:bg-gray-700 rounded-lg">
                    <h4 class="font-medium text-gray-900 dark:text-white mb-2">Receipt to Match:</h4>
                    <div class="text-sm text-gray-600 dark:text-gray-300">
                        <div><strong>Merchant:</strong> {{ $receipt->merchant_name ?? 'Unknown' }}</div>
                        <div><strong>Amount:</strong> £{{ number_format($receipt->total_amount, 2) }}</div>
                        <div><strong>Date:</strong> {{ $receipt->receipt_date?->format('d M Y') ?? 'No date' }}</div>
                    </div>
                </div>

                <!-- Search and Filter Controls -->
                <div class="mb-4">
                    <div class="flex gap-3 mb-3">
                        <!-- Search Input -->
                        <div class="flex-1">
                            <input type="text" 
                                   wire:model.live.debounce.300ms="manualMatchSearch" 
                                   placeholder="Search by merchant, amount, or description..." 
                                   class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-600 rounded-lg focus:ring-2 focus:ring-purple-500 focus:border-purple-500 dark:bg-gray-700 dark:text-white">
                        </div>
                        
                        <!-- Sort Controls -->
                        <div class="flex gap-2">
                            <button wire:click="setManualMatchSort('date')" 
                                    class="px-3 py-2 text-xs rounded-lg border {{ $manualMatchSortBy === 'date' ? 'bg-purple-100 border-purple-300 text-purple-700 dark:bg-purple-900/30 dark:border-purple-600 dark:text-purple-300' : 'bg-gray-100 border-gray-300 text-gray-700 dark:bg-gray-600 dark:border-gray-500 dark:text-gray-300' }}">
                                Date
                                @if($manualMatchSortBy === 'date')
                                    <svg class="w-3 h-3 inline ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $manualMatchSortOrder === 'asc' ? 'M5 15l7-7 7 7' : 'M19 9l-7 7-7-7' }}"/>
                                    </svg>
                                @endif
                            </button>
                            <button wire:click="setManualMatchSort('amount')" 
                                    class="px-3 py-2 text-xs rounded-lg border {{ $manualMatchSortBy === 'amount' ? 'bg-purple-100 border-purple-300 text-purple-700 dark:bg-purple-900/30 dark:border-purple-600 dark:text-purple-300' : 'bg-gray-100 border-gray-300 text-gray-700 dark:bg-gray-600 dark:border-gray-500 dark:text-gray-300' }}">
                                Amount
                                @if($manualMatchSortBy === 'amount')
                                    <svg class="w-3 h-3 inline ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $manualMatchSortOrder === 'asc' ? 'M5 15l7-7 7 7' : 'M19 9l-7 7-7-7' }}"/>
                                    </svg>
                                @endif
                            </button>
                            <button wire:click="setManualMatchSort('merchant')" 
                                    class="px-3 py-2 text-xs rounded-lg border {{ $manualMatchSortBy === 'merchant' ? 'bg-purple-100 border-purple-300 text-purple-700 dark:bg-purple-900/30 dark:border-purple-600 dark:text-purple-300' : 'bg-gray-100 border-gray-300 text-gray-700 dark:bg-gray-600 dark:border-gray-500 dark:text-gray-300' }}">
                                Merchant
                                @if($manualMatchSortBy === 'merchant')
                                    <svg class="w-3 h-3 inline ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $manualMatchSortOrder === 'asc' ? 'M5 15l7-7 7 7' : 'M19 9l-7 7-7-7' }}"/>
                                    </svg>
                                @endif
                            </button>
                        </div>
                    </div>
                    
                    <!-- Match Summary -->
                    @if($receipt)
                        <div class="text-xs text-gray-600 dark:text-gray-400 mb-2">
                            Looking for: <span class="font-medium">£{{ number_format($receipt->total_amount, 2) }}</span>
                            @if($receipt->currency !== 'GBP')
                                ({{ $receipt->currency }})
                            @endif
                            from <span class="font-medium">{{ $receipt->merchant_name }}</span>
                        </div>
                    @endif
                </div>

                <!-- Transaction Selection -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                        Select Statement Transaction:
                    </label>
                    <div class="max-h-64 overflow-y-auto border border-gray-300 dark:border-gray-600 rounded-lg">
                        @forelse($transactions as $transaction)
                        @php
                            $isExactAmountMatch = $receipt && $transaction->amount == $receipt->total_amount;
                            $isForeignAmountMatch = $receipt && $transaction->original_amount && $transaction->original_amount == $receipt->total_amount;
                            $isMerchantMatch = $receipt && $transaction->merchant_name && $receipt->merchant_name && 
                                             stripos($transaction->merchant_name, $receipt->merchant_name) !== false;
                        @endphp
                        <div class="p-3 border-b border-gray-200 dark:border-gray-600 hover:bg-gray-50 dark:hover:bg-gray-700 cursor-pointer {{ $manualMatchTransactionId === $transaction->id ? 'bg-blue-50 dark:bg-blue-900/20 border-blue-200 dark:border-blue-700' : '' }} {{ $isExactAmountMatch || $isForeignAmountMatch ? 'bg-green-50 dark:bg-green-900/20' : '' }}"
                             wire:click="setManualMatchTransaction({{ $transaction->id }})">
                            <div class="flex justify-between items-start">
                                <div class="flex-1">
                                    <div class="flex items-center gap-2">
                                        <div class="font-medium text-gray-900 dark:text-white">{{ $transaction->merchant_name }}</div>
                                        @if($isMerchantMatch)
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900/30 dark:text-blue-300">
                                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                                                </svg>
                                                Merchant Match
                                            </span>
                                        @endif
                                    </div>
                                    <div class="text-sm text-gray-600 dark:text-gray-300 flex items-center gap-2">
                                        <span>{{ $transaction->transaction_date->format('d M Y') }}</span>
                                        <span>•</span>
                                        <span class="font-medium {{ $isExactAmountMatch ? 'text-green-600 dark:text-green-400' : '' }}">
                                            £{{ number_format($transaction->amount, 2) }}
                                        </span>
                                        @if($isExactAmountMatch)
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900/30 dark:text-green-300">
                                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                                                </svg>
                                                Exact Amount
                                            </span>
                                        @elseif($isForeignAmountMatch)
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-900/30 dark:text-yellow-300">
                                                <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h10a8 8 0 018 8v2M3 10l6 6m-6-6l6-6"/>
                                                </svg>
                                                Foreign Amount
                                            </span>
                                        @endif
                                    </div>
                                    @if($transaction->original_amount && $transaction->original_currency && $transaction->original_currency !== 'GBP')
                                        <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                            Original: {{ number_format($transaction->original_amount, 2) }} {{ $transaction->original_currency }}
                                        </div>
                                    @endif
                                    @if($transaction->description)
                                        <div class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ Str::limit($transaction->description, 60) }}</div>
                                    @endif
                                </div>
                                @if($manualMatchTransactionId === $transaction->id)
                                    <svg class="w-5 h-5 text-blue-600 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                    </svg>
                                @endif
                            </div>
                        </div>
                        @empty
                        <div class="p-4 text-center text-gray-500 dark:text-gray-400">
                            @if(!empty($manualMatchSearch))
                                No transactions found matching "{{ $manualMatchSearch }}". Try a different search term.
                            @else
                                No transactions available for matching. This could mean:
                                <ul class="text-xs mt-2 space-y-1">
                                    <li>• No open statements with transactions</li>
                                    <li>• No transactions match the receipt amount</li>
                                    <li>• All transactions are already matched</li>
                                </ul>
                            @endif
                        </div>
                        @endforelse
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="flex justify-end space-x-3">
                    <button wire:click="closeManualMatchModal" 
                            class="px-4 py-2 text-sm font-medium text-gray-700 dark:text-gray-300 bg-gray-100 dark:bg-gray-600 hover:bg-gray-200 dark:hover:bg-gray-500 rounded-md transition-colors">
                        Cancel
                    </button>
                    <button wire:click="confirmManualMatch" 
                            @if(!$manualMatchTransactionId) disabled @endif
                            class="px-4 py-2 text-sm font-medium text-white bg-purple-600 hover:bg-purple-700 disabled:opacity-50 disabled:cursor-not-allowed rounded-md transition-colors">
                        Confirm Match
                    </button>
                </div>
                @endif
            @endif
            </div>
        </div>
    </div>
    {{-- @endif --}}
</div>
