<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        @livewireStyles
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-surface-light dark:bg-surface-dark">
            <div class="flex min-h-screen">
                <div class="flex-1 flex flex-col">
                    <header class="header">
                        <div class="py-4 px-4 sm:px-6 lg:px-8 flex items-center">
                            <h1 class="text-2xl font-bold text-gradient">
                                ExpenseWise
                            </h1>
                        </div>
                    </header>
                    <main class="p-6 lg:p-8 space-y-6">
                        {{ $slot }}
                    </main>
                </div>
            </div>
        </div>
        @livewireScripts
    </body>
</html>
