<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans antialiased">
        <div class="min-h-screen bg-gray-50 dark:bg-gray-900">
            <div class="flex min-h-screen">
                <aside class="hidden md:block w-64 bg-white dark:bg-gray-800 border-r border-gray-100 dark:border-gray-700">
                    <div class="p-4 font-semibold text-lg">ExpenseWise</div>
                    <div class="px-2">
                        @livewire('layout.navigation')
                    </div>
                </aside>
                <div class="flex-1 flex flex-col">
                    <header class="bg-white/70 dark:bg-gray-800/70 backdrop-blur border-b border-gray-100 dark:border-gray-700">
                        <div class="max-w-7xl mx-auto py-4 px-4 sm:px-6 lg:px-8">
                            {{ $header ?? '' }}
                        </div>
                    </header>
                    <main class="p-4 sm:p-6 lg:p-8">
                        {{ $slot }}
                    </main>
                </div>
            </div>
        </div>
    </body>
</html>
