const db = require('./src/db-multi-tenant');

async function checkUser() {
  try {
    const result = await db.pool.query(`
      SELECT id, username, email, subscription_tier, subscription_status, 
             stripe_customer_id, stripe_subscription_id
      FROM users
      WHERE id = 8
    `);
    
    console.log('Database row:', result.rows[0]);
    
    const user = await db.getUserById(8);
    console.log('\ngetUserById result:', {
      id: user.id,
      username: user.username,
      subscriptionTier: user.subscriptionTier,
      subscription_tier: user.subscription_tier,
      stripeCustomerId: user.stripeCustomerId,
      stripe_customer_id: user.stripe_customer_id
    });
    
  } catch (error) {
    console.error('Error:', error);
  } finally {
    process.exit(0);
  }
}

checkUser();

