<?php

namespace Tests\Unit;

use Tests\TestCase;
use Illuminate\Foundation\Testing\RefreshDatabase;
use App\Services\StatementImportService;
use Illuminate\Support\Facades\Storage;

class StatementImportTest extends TestCase
{
    use RefreshDatabase;

    public function test_import_parses_headers(): void
    {
        Storage::fake('local');
        $service = app(StatementImportService::class);
        $csv = implode("\n", [
            'Cardholder Name,Account Number,Transaction Date,Merchant Name,Amount,Currency,Original Amount,Original Currency,Conversion Rate,Posted Date,Transaction Time,Authorisation Code,Transaction ID,Merchant Category,Transaction Type,MCC Description,Merchant Town/City,Merchant County/State,Merchant Post code/Zipcode,MCC,Statement Cycle,Receipt?,"Details \n(Travel | Subsistence | Entertainment etc)",Department',
            'O THOMAS,****5318,22/05/2025,a.saily,21.59,GBP,27.99,USD,1.296433534,22/05/2025,75410,97703,MPB19XGNW,Digital Goods,PURCHASE,Digital Goods: Applications (Excludes Games),London,GBR,SE19 3HF,5817,,,E-Sim,,',
        ]);
        $path = Storage::disk('local')->path('test.csv');
        file_put_contents($path, $csv);

        $res = $service->import($path, 'O THOMAS', '****5318', '2025-05-01', '2025-05-31', 'test.csv', 'test.csv');
        $this->assertSame(1, $res['transactions_imported']);
    }
}
