<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <title>Vybe - Your Wellness Journey Starts Here</title>
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=quicksand:400,600,700&family=inter:400,500&display=swap" rel="stylesheet" />
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="antialiased font-sans bg-gradient-to-br from-primary-50 via-accent-50 to-primary-100">
        <!-- Navigation -->
        <nav class="bg-white/90 backdrop-blur-md border-b border-neutral-200/50 sticky top-0 z-50 shadow-sm">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <h1 class="text-2xl font-bold font-heading text-primary-600">Vybe</h1>
                        </div>
                    </div>
                    <div class="flex items-center space-x-4">
                        @if (Route::has('login'))
                            <livewire:welcome.navigation />
                        @endif
                    </div>
                </div>
            </div>
        </nav>

        <!-- Hero Section -->
        <div class="relative overflow-hidden">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24">
                <div class="text-center">
                    <h1 class="text-4xl md:text-6xl font-bold font-heading text-neutral-900 mb-6 tracking-heading">
                        Transform Your
                        <span class="text-transparent bg-clip-text bg-gradient-to-r from-primary-500 to-accent-500">
                            Wellness Journey
                        </span>
                    </h1>
                    <p class="text-xl text-neutral-600 mb-8 max-w-3xl mx-auto leading-relaxed">
                        Discover personalized wellness content, guided sessions, and track your progress with Vybe. 
                        Your path to better mental and physical health starts here.
                    </p>
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        @auth
                            <a href="{{ route('dashboard') }}" 
                               class="inline-flex items-center px-8 py-3 border border-transparent text-base font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01] shadow-md hover:shadow-lg">
                                Go to Dashboard
                            </a>
                        @else
                            <a href="{{ route('register') }}" 
                               class="inline-flex items-center px-8 py-3 border border-transparent text-base font-medium rounded-full text-white bg-gradient-to-r from-primary-400 to-primary-500 hover:from-primary-500 hover:to-primary-600 transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01] shadow-md hover:shadow-lg">
                                Get Started Free
                            </a>
                            <a href="{{ route('login') }}" 
                               class="inline-flex items-center px-8 py-3 border border-neutral-300 text-base font-medium rounded-full text-neutral-700 bg-white hover:bg-neutral-50 transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01] shadow-md hover:shadow-lg">
                                Sign In
                            </a>
                        @endauth
                    </div>
                </div>
            </div>
        </div>

        <!-- Features Section -->
        <div class="py-24 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-3xl font-bold font-heading text-neutral-900 mb-4 tracking-heading">
                        Everything You Need for Wellness
                    </h2>
                    <p class="text-xl text-neutral-600 max-w-2xl mx-auto leading-relaxed">
                        From guided meditation to fitness tracking, Vybe provides comprehensive tools to support your wellness journey.
                    </p>
                </div>

                <div class="grid md:grid-cols-3 gap-8">
                    <!-- Feature 1 -->
                    <div class="text-center p-8 rounded-2xl bg-gradient-to-br from-primary-50 to-primary-100 shadow-md hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01]">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-primary-200 mb-6">
                            <svg class="h-8 w-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold font-heading text-neutral-900 mb-3">Personalized Content</h3>
                        <p class="text-neutral-600 leading-relaxed">Get wellness content tailored to your preferences, goals, and current mood.</p>
                    </div>

                    <!-- Feature 2 -->
                    <div class="text-center p-8 rounded-2xl bg-gradient-to-br from-accent-50 to-accent-100 shadow-md hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01]">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-accent-200 mb-6">
                            <svg class="h-8 w-8 text-accent-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold font-heading text-neutral-900 mb-3">Progress Tracking</h3>
                        <p class="text-neutral-600 leading-relaxed">Monitor your wellness journey with detailed insights and progress analytics.</p>
                    </div>

                    <!-- Feature 3 -->
                    <div class="text-center p-8 rounded-2xl bg-gradient-to-br from-primary-50 to-accent-100 shadow-md hover:shadow-lg transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01]">
                        <div class="mx-auto flex items-center justify-center h-16 w-16 rounded-full bg-primary-200 mb-6">
                            <svg class="h-8 w-8 text-primary-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-semibold font-heading text-neutral-900 mb-3">Guided Sessions</h3>
                        <p class="text-neutral-600 leading-relaxed">Access a library of guided wellness sessions for meditation, exercise, and relaxation.</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="py-24 bg-gradient-to-r from-primary-500 to-accent-500">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 class="text-3xl font-bold font-heading text-white mb-4 tracking-heading">
                    Ready to Start Your Wellness Journey?
                </h2>
                <p class="text-xl text-primary-100 mb-8 max-w-2xl mx-auto leading-relaxed">
                    Join thousands of users who have transformed their lives with Vybe. 
                    Start your free journey today.
                </p>
                @guest
                    <a href="{{ route('register') }}" 
                       class="inline-flex items-center px-8 py-3 border border-transparent text-base font-medium rounded-full text-primary-600 bg-white hover:bg-neutral-50 transition-all duration-300 transform hover:translate-y-[-2px] hover:scale-[1.01] shadow-md hover:shadow-lg">
                        Create Your Free Account
                    </a>
                @endguest
            </div>
        </div>

        <!-- Footer -->
        <footer class="bg-neutral-900 text-white py-12">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center">
                    <h3 class="text-2xl font-bold font-heading text-primary-400 mb-4">Vybe</h3>
                    <p class="text-neutral-400 mb-6 leading-relaxed">
                        Empowering your wellness journey with personalized content and guidance.
                    </p>
                    <div class="border-t border-neutral-800 pt-6">
                        <p class="text-neutral-500 text-sm">
                            &copy; {{ date('Y') }} Vybe. All rights reserved.
                        </p>
                    </div>
                </div>
            </div>
        </footer>
    </body>
</html>
