@extends('layouts.frontend')

@section('meta_title', 'Knitting & Crochet Patterns - Project Ideas - Yarn Store')
@section('meta_description', 'Find inspiration for your next knitting or crochet project. Free patterns, tips, and project ideas for all skill levels.')
@section('meta_keywords', 'knitting patterns, crochet patterns, free patterns, knitting projects, crochet projects, beginner patterns')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-12">
            <nav class="ys-breadcrumb">
                <a href="{{ route('home') }}">Home</a>
                <span>/</span>
                <span>Patterns & Projects</span>
            </nav>
        </div>
    </div>

    <div class="row mb-5">
        <div class="col-lg-8 mx-auto text-center">
            <h1 class="display-4 fw-bold mb-3">Patterns & Project Ideas</h1>
            <p class="lead text-muted">
                Get inspired for your next knitting or crochet project with our curated collection of ideas and resources
            </p>
        </div>
    </div>

    <!-- Coming Soon Notice -->
    <div class="row mb-5">
        <div class="col-lg-8 mx-auto">
            <div class="ys-card p-5 text-center">
                <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="var(--ys-primary)" class="mb-3" viewBox="0 0 16 16">
                    <path d="M1 2.5A1.5 1.5 0 0 1 2.5 1h3A1.5 1.5 0 0 1 7 2.5v3A1.5 1.5 0 0 1 5.5 7h-3A1.5 1.5 0 0 1 1 5.5v-3zM2.5 2a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zm6.5.5A1.5 1.5 0 0 1 10.5 1h3A1.5 1.5 0 0 1 15 2.5v3A1.5 1.5 0 0 1 13.5 7h-3A1.5 1.5 0 0 1 9 5.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zM1 10.5A1.5 1.5 0 0 1 2.5 9h3A1.5 1.5 0 0 1 7 10.5v3A1.5 1.5 0 0 1 5.5 15h-3A1.5 1.5 0 0 1 1 13.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3zm6.5.5A1.5 1.5 0 0 1 10.5 9h3a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1-1.5 1.5h-3A1.5 1.5 0 0 1 9 13.5v-3zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5h-3z"/>
                </svg>
                <h2 class="h3 fw-bold mb-3">Patterns Library Coming Soon</h2>
                <p class="text-muted mb-4">
                    We're working on creating an extensive library of free patterns and project ideas. 
                    Check back soon for updates!
                </p>
            </div>
        </div>
    </div>

    <!-- Project Ideas by Category -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Popular Project Ideas</h2>
        </div>

        <div class="col-lg-4 col-md-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Beginner Projects</h3>
                <ul class="text-muted small">
                    <li class="mb-2">Simple Garter Stitch Scarf</li>
                    <li class="mb-2">Basic Dishcloths</li>
                    <li class="mb-2">Easy Ribbed Hat</li>
                    <li class="mb-2">Simple Fingerless Gloves</li>
                    <li class="mb-2">Baby Blanket Squares</li>
                </ul>
                <p class="text-muted small mb-0">
                    Perfect for learning basic stitches and building confidence
                </p>
            </div>
        </div>

        <div class="col-lg-4 col-md-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Intermediate Projects</h3>
                <ul class="text-muted small">
                    <li class="mb-2">Cable Knit Sweater</li>
                    <li class="mb-2">Lace Shawl</li>
                    <li class="mb-2">Colorwork Mittens</li>
                    <li class="mb-2">Textured Throw Blanket</li>
                    <li class="mb-2">Socks with Heel Turn</li>
                </ul>
                <p class="text-muted small mb-0">
                    Expand your skills with cables, lace, and colorwork
                </p>
            </div>
        </div>

        <div class="col-lg-4 col-md-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Advanced Projects</h3>
                <ul class="text-muted small">
                    <li class="mb-2">Fair Isle Cardigan</li>
                    <li class="mb-2">Intricate Lace Doilies</li>
                    <li class="mb-2">Complex Cable Designs</li>
                    <li class="mb-2">Garments with Multiple Techniques</li>
                    <li class="mb-2">Custom-Designed Projects</li>
                </ul>
                <p class="text-muted small mb-0">
                    Challenge yourself with complex patterns and techniques
                </p>
            </div>
        </div>
    </div>

    <!-- Seasonal Projects -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Seasonal Project Ideas</h2>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Spring/Summer</h3>
                <div class="row">
                    <div class="col-md-6">
                        <ul class="text-muted small">
                            <li class="mb-2">Lightweight cardigans</li>
                            <li class="mb-2">Cotton tank tops</li>
                            <li class="mb-2">Market bags</li>
                            <li class="mb-2">Beach cover-ups</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul class="text-muted small">
                            <li class="mb-2">Sun hats</li>
                            <li class="mb-2">Baby summer dresses</li>
                            <li class="mb-2">Lace shawls</li>
                            <li class="mb-2">Table runners</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4 h-100">
                <h3 class="h5 fw-bold mb-3" style="color: var(--ys-primary);">Autumn/Winter</h3>
                <div class="row">
                    <div class="col-md-6">
                        <ul class="text-muted small">
                            <li class="mb-2">Cozy sweaters</li>
                            <li class="mb-2">Chunky scarves</li>
                            <li class="mb-2">Warm hats and beanies</li>
                            <li class="mb-2">Mittens and gloves</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <ul class="text-muted small">
                            <li class="mb-2">Thick socks</li>
                            <li class="mb-2">Blankets and throws</li>
                            <li class="mb-2">Cowls and infinity scarves</li>
                            <li class="mb-2">Slippers</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Tips & Techniques -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Essential Knitting & Crochet Tips</h2>
        </div>

        <div class="col-lg-4 col-md-6 mb-4">
            <div class="ys-card p-4 h-100 text-center">
                <div class="mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="var(--ys-primary)" viewBox="0 0 16 16">
                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                        <path d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286zm1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94z"/>
                    </svg>
                </div>
                <h3 class="h6 fw-bold mb-2">Always Gauge Swatch</h3>
                <p class="text-muted small mb-0">
                    Take time to create a gauge swatch to ensure your finished project matches the pattern dimensions
                </p>
            </div>
        </div>

        <div class="col-lg-4 col-md-6 mb-4">
            <div class="ys-card p-4 h-100 text-center">
                <div class="mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="var(--ys-primary)" viewBox="0 0 16 16">
                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/>
                        <path d="m10.97 4.97-.02.022-3.473 4.425-2.093-2.094a.75.75 0 0 0-1.06 1.06L6.97 11.03a.75.75 0 0 0 1.079-.02l3.992-4.99a.75.75 0 0 0-1.071-1.05z"/>
                    </svg>
                </div>
                <h3 class="h6 fw-bold mb-2">Read Pattern Fully</h3>
                <p class="text-muted small mb-0">
                    Read through the entire pattern before starting to understand the construction and techniques required
                </p>
            </div>
        </div>

        <div class="col-lg-4 col-md-6 mb-4">
            <div class="ys-card p-4 h-100 text-center">
                <div class="mb-3">
                    <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="var(--ys-primary)" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 1.314C12.438-3.248 23.534 4.735 8 15-7.534 4.736 3.562-3.248 8 1.314z"/>
                    </svg>
                </div>
                <h3 class="h6 fw-bold mb-2">Choose Quality Yarn</h3>
                <p class="text-muted small mb-0">
                    Invest in quality yarn that's appropriate for your project - it makes a difference in the final result
                </p>
            </div>
        </div>
    </div>

    <!-- Resources -->
    <div class="row mb-5">
        <div class="col-12">
            <h2 class="h3 fw-bold mb-4">Helpful Resources</h2>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4">
                <h3 class="h5 fw-bold mb-3">Popular Pattern Websites</h3>
                <ul class="text-muted small">
                    <li class="mb-2"><a href="https://www.ravelry.com" target="_blank" class="text-primary">Ravelry</a> - Extensive pattern library and community</li>
                    <li class="mb-2"><a href="https://www.yarnspirations.com" target="_blank" class="text-primary">Yarnspirations</a> - Free patterns for all skill levels</li>
                    <li class="mb-2"><a href="https://www.allfreeknitting.com" target="_blank" class="text-primary">AllFreeKnitting</a> - Thousands of free knitting patterns</li>
                    <li class="mb-2"><a href="https://www.purlsoho.com" target="_blank" class="text-primary">Purl Soho</a> - Beautifully photographed modern patterns</li>
                </ul>
            </div>
        </div>

        <div class="col-lg-6 mb-4">
            <div class="ys-card p-4">
                <h3 class="h5 fw-bold mb-3">Learning Resources</h3>
                <ul class="text-muted small">
                    <li class="mb-2">YouTube tutorials for visual learners</li>
                    <li class="mb-2">Local knitting groups and workshops</li>
                    <li class="mb-2">Online forums and communities</li>
                    <li class="mb-2">Knitting and crochet apps for patterns and counters</li>
                </ul>
            </div>
        </div>
    </div>

    <!-- CTA -->
    <div class="row">
        <div class="col-lg-8 mx-auto text-center">
            <div class="ys-card p-5" style="background: linear-gradient(135deg, var(--ys-primary) 0%, var(--ys-primary-dark) 100%);">
                <h2 class="h3 fw-bold mb-3 text-white">Ready to Start Your Next Project?</h2>
                <p class="text-white mb-4">
                    Browse our collections to find the perfect yarn for your next creation.
                </p>
                <a href="{{ route('collections') }}" class="btn btn-light btn-lg">
                    Shop Yarn Collections
                </a>
            </div>
        </div>
    </div>
</div>
@endsection

