#!/usr/bin/env sh
set -e

export PORT=${PORT:-8080}

cd /var/www/html

# Generate key if missing
if [ ! -f storage/app/.app_key_set ]; then
  php artisan key:generate --force || true
  mkdir -p storage/app
  touch storage/app/.app_key_set || true
fi

# Storage symlink
php artisan storage:link || true

# Optimize caches
php artisan config:cache || true
php artisan route:cache || true
php artisan view:cache || true

exec "$@"

