<?php

use Illuminate\Support\Facades\Route;

Route::prefix('v1')->group(function () {
    Route::get('/tracks', [\App\Http\Controllers\Api\V1\TracksController::class, 'index']);
    Route::get('/tags', [\App\Http\Controllers\Api\V1\TagsController::class, 'index']);

    Route::get('/profile', [\App\Http\Controllers\Api\V1\ProfileController::class, 'show']);
    Route::patch('/profile', [\App\Http\Controllers\Api\V1\ProfileController::class, 'update']);

    Route::get('/favorites', [\App\Http\Controllers\Api\V1\FavoritesController::class, 'index']);
    Route::post('/favorites/{track}/toggle', [\App\Http\Controllers\Api\V1\FavoritesController::class, 'toggle']);

    Route::post('/playback', [\App\Http\Controllers\Api\V1\PlaybackController::class, 'store']);
});


