<?php

use Illuminate\Support\Facades\Route;

Route::middleware(['auth:sanctum'])->prefix('v1')->group(function () {
    // Tracks
    Route::get('/tracks', [\App\Http\Controllers\Api\V1\TracksController::class, 'index']);
    Route::get('/tracks/{id}', [\App\Http\Controllers\Api\V1\TracksController::class, 'show']);

    // Tags
    Route::get('/tags', [\App\Http\Controllers\Api\V1\TagsController::class, 'index']);

    // Profile
    Route::get('/profile', [\App\Http\Controllers\Api\V1\ProfileController::class, 'show']);
    Route::patch('/profile', [\App\Http\Controllers\Api\V1\ProfileController::class, 'update']);

    // Favorites
    Route::post('/favorites/{track}', [\App\Http\Controllers\Api\V1\FavoritesController::class, 'toggle']);

    // Playback (rate limited)
    Route::post('/playback', [\App\Http\Controllers\Api\V1\PlaybackController::class, 'store'])
        ->middleware('throttle:playback');

    // Checkins (rate limited)
    Route::post('/checkins', [\App\Http\Controllers\Api\V1\CheckinsController::class, 'store'])
        ->middleware('throttle:checkins');

    // Memory
    Route::get('/memory/latest', [\App\Http\Controllers\Api\V1\MemoryController::class, 'latest']);
});


