<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.categories') }}" class="text-decoration-none">Categories</a>
                    </li>
                    <li class="breadcrumb-item active">{{ $category->name }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Category Details</h1>
            <p class="text-muted mb-0">View and manage category information and items</p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="cancel" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Category
                </button>
            @endif
        </div>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Category Information -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-tags me-2"></i>Category Information
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Basic Information -->
                    <div class="row g-4 mb-4">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-tag text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">Category Name</label>
                            </div>
                            @if($editing)
                                <input type="text" 
                                       wire:model="name" 
                                       class="form-control @error('name') is-invalid @enderror">
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fs-5 fw-medium text-body">{{ $category->name }}</div>
                            @endif
                        </div>
                        
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-link-45deg text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">URL Slug</label>
                            </div>
                            @if($editing)
                                <input type="text" 
                                       wire:model="slug" 
                                       class="form-control @error('slug') is-invalid @enderror">
                                @error('slug') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fs-5 fw-medium text-body">{{ $category->slug }}</div>
                            @endif
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="border-top pt-4 mb-4">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-file-text text-primary me-2"></i>
                            <label class="form-label fw-semibold mb-0">Description</label>
                        </div>
                        @if($editing)
                            <textarea wire:model="description" 
                                      class="form-control @error('description') is-invalid @enderror" 
                                      rows="4" 
                                      placeholder="Enter category description..."></textarea>
                            @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        @else
                            <div class="text-body">
                                {{ $category->description ?: 'No description provided' }}
                            </div>
                        @endif
                    </div>

                    <!-- Settings -->
                    <div class="border-top pt-4">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-sort-numeric-up text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Sort Order</label>
                                </div>
                                @if($editing)
                                    <input type="number" 
                                           wire:model="sortOrder" 
                                           class="form-control @error('sortOrder') is-invalid @enderror" 
                                           min="0">
                                    @error('sortOrder') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                    <span class="badge bg-light text-dark fs-6">{{ $category->sort_order }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
