<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-2">
                    <li class="breadcrumb-item">
                        <a href="{{ route('admin.categories') }}" class="text-decoration-none">Categories</a>
                    </li>
                    <li class="breadcrumb-item active">{{ $category->name }}</li>
                </ol>
            </nav>
            <h1 class="h3 mb-1">Category Details</h1>
            <p class="text-muted mb-0">View and manage category information and items</p>
        </div>
        <div class="btn-group">
            @if($editing)
                <button wire:click="save" class="btn btn-success">
                    <i class="bi bi-check-lg me-2"></i>Save Changes
                </button>
                <button wire:click="cancel" class="btn btn-outline-secondary">
                    <i class="bi bi-x-lg me-2"></i>Cancel
                </button>
            @else
                <button wire:click="toggleEdit" class="btn btn-primary">
                    <i class="bi bi-pencil me-2"></i>Edit Category
                </button>
            @endif
        </div>
    </div>

    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="bi bi-check-circle me-2"></i>{{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif

    <div class="row">
        <!-- Category Information -->
        <div class="col-lg-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-tags me-2"></i>Category Information
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Basic Information -->
                    <div class="row g-4 mb-4">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-tag text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">Category Name</label>
                            </div>
                            @if($editing)
                                <input type="text" 
                                       wire:model="name" 
                                       class="form-control @error('name') is-invalid @enderror">
                                @error('name') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fs-5 fw-medium text-body">{{ $category->name }}</div>
                            @endif
                        </div>
                        
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-2">
                                <i class="bi bi-link-45deg text-primary me-2"></i>
                                <label class="form-label fw-semibold mb-0">URL Slug</label>
                            </div>
                            @if($editing)
                                <input type="text" 
                                       wire:model="slug" 
                                       class="form-control @error('slug') is-invalid @enderror">
                                @error('slug') <div class="invalid-feedback">{{ $message }}</div> @enderror
                            @else
                                <div class="fs-5 fw-medium text-body">{{ $category->slug }}</div>
                            @endif
                        </div>
                    </div>

                    <!-- Description -->
                    <div class="border-top pt-4 mb-4">
                        <div class="d-flex align-items-center mb-2">
                            <i class="bi bi-file-text text-primary me-2"></i>
                            <label class="form-label fw-semibold mb-0">Description</label>
                        </div>
                        @if($editing)
                            <textarea wire:model="description" 
                                      class="form-control @error('description') is-invalid @enderror" 
                                      rows="4" 
                                      placeholder="Enter category description..."></textarea>
                            @error('description') <div class="invalid-feedback">{{ $message }}</div> @enderror
                        @else
                            <div class="text-body">
                                {{ $category->description ?: 'No description provided' }}
                            </div>
                        @endif
                    </div>

                    <!-- Settings -->
                    <div class="border-top pt-4">
                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="d-flex align-items-center mb-2">
                                    <i class="bi bi-sort-numeric-up text-primary me-2"></i>
                                    <label class="form-label fw-semibold mb-0">Sort Order</label>
                                </div>
                                @if($editing)
                                    <input type="number" 
                                           wire:model="sortOrder" 
                                           class="form-control @error('sortOrder') is-invalid @enderror" 
                                           min="0">
                                    @error('sortOrder') <div class="invalid-feedback">{{ $message }}</div> @enderror
                                @else
                                    <span class="badge bg-light text-dark fs-6">{{ $category->sort_order }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Category Stats -->
        <div class="col-lg-4">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-graph-up me-2"></i>Category Stats
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="text-muted small">Total Items</div>
                                    <div class="h4 mb-0">{{ $items->count() }}</div>
                                </div>
                                <i class="bi bi-box text-primary fs-2"></i>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="text-muted small">Status</div>
                                    <div class="h6 mb-0">
                                        @if($category->is_active)
                                            <span class="badge bg-success">
                                                <i class="bi bi-check-circle me-1"></i>Active
                                            </span>
                                        @else
                                            <span class="badge bg-secondary">
                                                <i class="bi bi-pause-circle me-1"></i>Inactive
                                            </span>
                                        @endif
                                    </div>
                                </div>
                                <i class="bi bi-shield-check text-info fs-2"></i>
                            </div>
                        </div>
                        
                        <div class="col-12">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <div class="text-muted small">Created</div>
                                    <div class="h6 mb-0">{{ $category->created_at->format('M j, Y') }}</div>
                                </div>
                                <i class="bi bi-calendar-plus text-warning fs-2"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Category Settings -->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="bi bi-gear me-2"></i>Settings
                    </h5>
                </div>
                <div class="card-body">
                    <div class="d-flex align-items-center mb-2">
                        <i class="bi bi-toggle-on text-primary me-2"></i>
                        <label class="form-label fw-semibold mb-0">Active Status</label>
                    </div>
                    @if($editing)
                        <div class="form-check form-switch">
                            <input type="checkbox" 
                                   wire:model="isActive" 
                                   class="form-check-input @error('isActive') is-invalid @enderror" 
                                   id="isActive">
                            <label class="form-check-label" for="isActive">
                                Category is active
                            </label>
                        </div>
                        @error('isActive') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    @else
                        <div class="d-flex align-items-center">
                            @if($category->is_active)
                                <span class="badge bg-success me-2">
                                    <i class="bi bi-check-circle me-1"></i>Active
                                </span>
                            @else
                                <span class="badge bg-secondary me-2">
                                    <i class="bi bi-x-circle me-1"></i>Inactive
                                </span>
                            @endif
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Items Section -->
    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="bi bi-list-ul me-2"></i>Category Items
                </h5>
                <div class="d-flex align-items-center gap-2">
                    <label class="form-label mb-0 small">Per page:</label>
                    <select class="form-select form-select-sm" style="width: auto;">
                        <option value="5">5</option>
                        <option value="10">10</option>
                        <option value="25">25</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="card-body p-0">
            @if($items->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Item</th>
                                <th class="border-0">SKU</th>
                                <th class="border-0">Price</th>
                                <th class="border-0">Status</th>
                                <th class="border-0 text-end">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($items as $item)
                                <tr>
                                    <td>
                                        <div class="fw-semibold">{{ $item->name ?? 'Sample Item' }}</div>
                                    </td>
                                    <td>
                                        <span class="badge bg-light text-dark">{{ $item->sku ?? 'SKU-001' }}</span>
                                    </td>
                                    <td>
                                        <div class="fw-semibold">${{ $item->price ?? '0.00' }}</div>
                                    </td>
                                    <td>
                                        <span class="badge bg-success">Active</span>
                                    </td>
                                    <td class="text-end">
                                        <button class="btn btn-outline-primary btn-sm">
                                            <i class="bi bi-eye"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <!-- Empty Items State -->
                <div class="text-center py-5">
                    <i class="bi bi-box display-1 text-muted"></i>
                    <h4 class="mt-3">No items found</h4>
                    <p class="text-muted">This category doesn't have any items yet.</p>
                </div>
            @endif
        </div>
    </div>
</div>
