// Database abstraction layer - supports PostgreSQL (default) or JSON
const USE_POSTGRES = process.env.USE_POSTGRES !== 'false'; // PostgreSQL by default
const USE_JSON = process.env.USE_JSON === 'true'; // JSON as optional fallback

// Import the appropriate database module
let dbModule;

if (USE_JSON) {
  console.log('Using JSON database (lightweight, cloud-friendly)');
  dbModule = require('./db-json');
} else if (USE_POSTGRES) {
  console.log('Using PostgreSQL database');
  dbModule = require('./db-postgres');
} else {
  console.error('No valid database configuration found!');
  console.error('Set USE_POSTGRES=true (recommended) or USE_JSON=true');
  process.exit(1);
}

// Export the database module (PostgreSQL or JSON)
module.exports = dbModule;
