@extends('layouts.frontend')

@section('meta_title', 'Privacy Policy - Yarn Store')
@section('meta_description', 'Learn how Yarn Store by Robert Todd Yarn collects, uses, and protects your personal information.')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <h1 class="display-5 fw-bold mb-4">Privacy Policy</h1>
            <p class="text-muted mb-5">Last updated: {{ date('F d, Y') }}</p>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">1. Introduction</h2>
                <p class="text-muted">
                    Robert Todd Yarn (trading as "Yarn Store") is committed to protecting your privacy and ensuring the 
                    security of your personal information. This Privacy Policy explains how we collect, use, and safeguard 
                    your data in compliance with the UK General Data Protection Regulation (UK GDPR) and the Data Protection Act 2018.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">2. Information We Collect</h2>
                <h3 class="h6 fw-semibold mb-2">Personal Information</h3>
                <p class="text-muted mb-3">
                    When you place an order or create an account, we collect:
                </p>
                <ul class="text-muted">
                    <li>Name and contact details (email address, phone number)</li>
                    <li>Billing and delivery addresses</li>
                    <li>Payment information (processed securely by our payment provider)</li>
                    <li>Order history and preferences</li>
                </ul>

                <h3 class="h6 fw-semibold mb-2 mt-3">Technical Information</h3>
                <ul class="text-muted">
                    <li>IP address</li>
                    <li>Browser type and version</li>
                    <li>Device information</li>
                    <li>Cookies and similar tracking technologies (see our <a href="{{ route('cookies') }}" class="text-primary">Cookie Policy</a>)</li>
                </ul>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">3. How We Use Your Information</h2>
                <p class="text-muted mb-3">We use your personal information to:</p>
                <ul class="text-muted">
                    <li>Process and fulfill your orders</li>
                    <li>Communicate with you about your orders and account</li>
                    <li>Provide customer support</li>
                    <li>Send you marketing communications (with your consent)</li>
                    <li>Improve our website and services</li>
                    <li>Prevent fraud and ensure website security</li>
                    <li>Comply with legal obligations</li>
                </ul>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">4. Legal Basis for Processing</h2>
                <p class="text-muted">
                    We process your personal data on the following legal bases:
                </p>
                <ul class="text-muted">
                    <li><strong>Contract Performance:</strong> To fulfill our contract with you when you place an order</li>
                    <li><strong>Legitimate Interests:</strong> To improve our services and prevent fraud</li>
                    <li><strong>Consent:</strong> For marketing communications and non-essential cookies</li>
                    <li><strong>Legal Obligation:</strong> To comply with tax and accounting requirements</li>
                </ul>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">5. Data Sharing</h2>
                <p class="text-muted mb-3">
                    We may share your information with:
                </p>
                <ul class="text-muted">
                    <li><strong>Service Providers:</strong> Payment processors, delivery companies, email service providers</li>
                    <li><strong>Legal Requirements:</strong> When required by law or to protect our rights</li>
                </ul>
                <p class="text-muted">
                    We do not sell your personal information to third parties.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">6. Data Retention</h2>
                <p class="text-muted">
                    We retain your personal information for as long as necessary to fulfill the purposes outlined in this policy:
                </p>
                <ul class="text-muted">
                    <li>Order information: 7 years (for tax and legal purposes)</li>
                    <li>Account information: Until you request deletion</li>
                    <li>Marketing preferences: Until you unsubscribe</li>
                </ul>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">7. Your Rights</h2>
                <p class="text-muted mb-3">
                    Under UK GDPR, you have the following rights:
                </p>
                <ul class="text-muted">
                    <li><strong>Right of Access:</strong> Request a copy of your personal data</li>
                    <li><strong>Right to Rectification:</strong> Correct inaccurate or incomplete data</li>
                    <li><strong>Right to Erasure:</strong> Request deletion of your data (subject to legal obligations)</li>
                    <li><strong>Right to Restriction:</strong> Limit how we use your data</li>
                    <li><strong>Right to Data Portability:</strong> Receive your data in a machine-readable format</li>
                    <li><strong>Right to Object:</strong> Object to processing based on legitimate interests</li>
                    <li><strong>Right to Withdraw Consent:</strong> Withdraw consent for marketing or cookies at any time</li>
                </ul>
                <p class="text-muted">
                    To exercise any of these rights, please <a href="{{ route('contact') }}" class="text-primary">contact us</a>.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">8. Data Security</h2>
                <p class="text-muted">
                    We implement appropriate technical and organizational measures to protect your personal information against 
                    unauthorized access, alteration, disclosure, or destruction. However, no method of transmission over the 
                    internet is 100% secure.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">9. Children's Privacy</h2>
                <p class="text-muted">
                    Our website is not intended for children under 16. We do not knowingly collect personal information from children.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">10. Changes to This Policy</h2>
                <p class="text-muted">
                    We may update this Privacy Policy from time to time. We will notify you of any significant changes by 
                    posting the new policy on this page with an updated "Last updated" date.
                </p>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">11. Contact Us</h2>
                <p class="text-muted mb-3">
                    If you have any questions about this Privacy Policy or wish to exercise your rights, please contact us:
                </p>
                <a href="{{ route('contact') }}" class="btn btn-ys-primary">
                    Contact Us
                </a>
            </div>

            <div class="ys-card p-4 mb-4">
                <h2 class="h4 fw-bold mb-3">12. Complaints</h2>
                <p class="text-muted">
                    If you are not satisfied with how we handle your personal data, you have the right to lodge a complaint 
                    with the Information Commissioner's Office (ICO):
                </p>
                <p class="text-muted">
                    <strong>ICO Website:</strong> <a href="https://ico.org.uk" target="_blank" class="text-primary">ico.org.uk</a><br>
                    <strong>Helpline:</strong> 0303 123 1113
                </p>
            </div>
        </div>
    </div>
</div>
@endsection

