<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Bootstrap CSS -->
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
        <!-- Custom Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Playfair+Display:wght@400;500;600;700&display=swap" rel="stylesheet">
        <!-- Bootstrap Icons -->
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
        <style>
            :root {
                --jen-primary: #6366f1;
                --jen-primary-dark: #4f46e5;
                --jen-secondary: #f8fafc;
                --jen-accent: #ec4899;
                --jen-success: #10b981;
                --jen-warning: #f59e0b;
                --jen-danger: #ef4444;
                --jen-text: #1e293b;
                --jen-text-light: #64748b;
                --jen-border: #e2e8f0;
            }
            
            body {
                font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
                background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
                color: var(--jen-text);
            }
            
            .navbar-brand {
                font-family: 'Playfair Display', serif;
                font-weight: 600;
                font-size: 1.5rem;
                color: var(--jen-primary) !important;
            }
            
            .card {
                border: none;
                border-radius: 16px;
                box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
                transition: all 0.3s ease;
            }
            
            .card:hover {
                transform: translateY(-2px);
                box-shadow: 0 10px 25px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            }
            
            .btn-primary {
                background: linear-gradient(135deg, var(--jen-primary) 0%, var(--jen-primary-dark) 100%);
                border: none;
                border-radius: 12px;
                font-weight: 600;
                padding: 12px 24px;
                transition: all 0.3s ease;
            }
            
            .btn-primary:hover {
                transform: translateY(-1px);
                box-shadow: 0 10px 25px -3px rgba(99, 102, 241, 0.3);
            }
            
            .form-control {
                border-radius: 12px;
                border: 2px solid var(--jen-border);
                padding: 12px 16px;
                transition: all 0.3s ease;
            }
            
            .form-control:focus {
                border-color: var(--jen-primary);
                box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
            }
            
            .table {
                border-radius: 12px;
                overflow: hidden;
            }
            
            .table thead th {
                background: linear-gradient(135deg, var(--jen-primary) 0%, var(--jen-primary-dark) 100%);
                color: white;
                border: none;
                font-weight: 600;
                padding: 12px 10px;
                white-space: nowrap;
            }
            .table-hover tbody tr:hover { background-color: rgba(99,102,241,.06); }
            .jen-table thead th { position: sticky; top: 0; z-index: 2; }
            .jen-table thead th {
                background: var(--jen-secondary) !important;
                color: var(--jen-text) !important;
                border-bottom: 1px solid var(--jen-border) !important;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
                font-weight: 600;
            }
            .jen-table td, .jen-table th { vertical-align: middle; }
            .jen-table { border-radius: 14px; overflow: hidden; }
            .address-cell { max-width: 260px; word-break: break-word; }
            .address-cell ul { margin: 0; padding-left: 1rem; }
            .address-cell li { line-height: 1.25rem; }
            .ref-cell { max-width: 220px; }
            .jen-pill { border-radius: 9999px; text-transform: uppercase; font-weight: 600; }
            
            .hero-section {
                background: linear-gradient(135deg, var(--jen-primary) 0%, var(--jen-accent) 100%);
                color: white;
                padding: 60px 0;
                margin-bottom: 40px;
            }
            
            .hero-title {
                font-family: 'Playfair Display', serif;
                font-weight: 700;
                font-size: 3rem;
                margin-bottom: 16px;
            }
            
            .hero-subtitle {
                font-size: 1.25rem;
                opacity: 0.9;
                font-weight: 400;
            }
            
            .stats-card {
                background: white;
                border-radius: 20px;
                padding: 32px;
                text-align: center;
                border: 1px solid var(--jen-border);
            }
            
            .stats-number {
                font-family: 'Playfair Display', serif;
                font-size: 2.5rem;
                font-weight: 700;
                color: var(--jen-primary);
                margin-bottom: 8px;
            }
            
            .stats-label {
                color: var(--jen-text-light);
                font-weight: 500;
                font-size: 0.9rem;
                text-transform: uppercase;
                letter-spacing: 0.5px;
            }
        </style>
        @livewireStyles
    </head>
    <body>
        <div class="min-vh-100">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @isset($header)
                <header class="bg-white shadow-sm border-bottom">
                    <div class="container py-4">
                        {{ $header }}
                    </div>
                </header>
            @endisset

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>
        </div>
        
        <!-- Bootstrap JS -->
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
        
        @livewireScripts
    </body>
</html>
