<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Vite Assets (includes Tailwind CSS) -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        <!-- Custom Fonts -->
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=Playfair+Display:wght@400;500;600;700&display=swap" rel="stylesheet">
        <style>
            :root {
                --jen-primary: #6366f1;
                --jen-primary-dark: #4f46e5;
                --jen-secondary: #f8fafc;
                --jen-accent: #ec4899;
                --jen-success: #10b981;
                --jen-warning: #f59e0b;
                --jen-danger: #ef4444;
                --jen-text: #1e293b;
                --jen-text-light: #64748b;
                --jen-border: #e2e8f0;
            }
            
            body {
                font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
                background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
                color: var(--jen-text);
                font-size: 0.95rem;
            }
            
            .navbar-brand {
                font-family: 'Playfair Display', serif;
                font-weight: 600;
                font-size: 1.25rem;
                color: var(--jen-primary) !important;
            }
            .navbar .nav-link { font-size: 0.92rem; padding: .5rem .75rem; }
            
            .card {
                border: none;
                border-radius: 12px;
                box-shadow: 0 2px 6px rgba(0, 0, 0, 0.06);
                transition: box-shadow 0.25s ease;
            }
            
            .card:hover {
                box-shadow: 0 6px 18px -4px rgba(0, 0, 0, 0.12);
            }
            
            .btn-primary {
                background: linear-gradient(135deg, var(--jen-primary) 0%, var(--jen-primary-dark) 100%);
                border: none;
                border-radius: 10px;
                font-weight: 600;
                padding: 8px 14px;
                font-size: 0.9rem;
                transition: transform 0.15s ease, box-shadow 0.25s ease;
            }
            
            .btn-primary:hover {
                transform: translateY(-1px);
                box-shadow: 0 8px 20px -6px rgba(99, 102, 241, 0.35);
            }
            
            .form-control {
                border-radius: 12px;
                border: 2px solid var(--jen-border);
                padding: 10px 12px;
                transition: box-shadow 0.25s ease, border-color 0.2s ease;
            }
            
            .form-control:focus {
                border-color: var(--jen-primary);
                box-shadow: 0 0 0 3px rgba(99, 102, 241, 0.1);
            }
            
            .table {
                border-radius: 12px;
                overflow: hidden;
            }
            
            .table thead th {
                background: linear-gradient(135deg, var(--jen-primary) 0%, var(--jen-primary-dark) 100%);
                color: white;
                border: none;
                font-weight: 600;
                padding: 16px 12px;
            }
            .table-hover tbody tr:hover { background-color: rgba(99,102,241,.06); }
            .jen-table thead th { position: sticky; top: 0; z-index: 2; }
            .jen-table thead th {
                background: var(--jen-secondary) !important;
                color: var(--jen-text) !important;
                border-bottom: 1px solid var(--jen-border) !important;
                white-space: normal; /* allow wrapping so full labels show */
                word-break: break-word;
                overflow: visible;
                text-overflow: clip;
                font-weight: 600;
                font-size: 0.75rem;
                line-height: 1.1rem;
                padding: 6px 8px !important;
            }
            .jen-table td, .jen-table th { vertical-align: middle; }
            .jen-table { font-size: 0.82rem; }
            .jen-table td { padding: 6px 8px; }
            .jen-table { border-radius: 14px; overflow: hidden; }
            .address-cell { max-width: 240px; word-break: break-word; }
            .address-cell ul { margin: 0; padding-left: .9rem; }
            .address-cell li { line-height: 1.05rem; font-size: 0.78rem; }
            .ref-cell { max-width: 200px; }
            .jen-pill { border-radius: 9999px; text-transform: uppercase; font-weight: 600; }
            
            .hero-section {
                background: linear-gradient(180deg, var(--jen-secondary) 0%, #eef2f7 100%);
                color: var(--jen-text);
                padding: 24px 0;
                margin-bottom: 20px;
            }
            
            .hero-title {
                font-family: 'Playfair Display', serif;
                font-weight: 700;
                font-size: 1.9rem;
                margin-bottom: 6px;
            }
            
            .hero-subtitle {
                font-size: 0.95rem;
                opacity: 0.8;
                font-weight: 400;
            }
            
            .stats-card {
                background: white;
                border-radius: 14px;
                padding: 18px;
                text-align: center;
                border: 1px solid var(--jen-border);
            }
            
            .stats-number {
                font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
                font-size: 1.4rem;
                font-weight: 700;
                color: var(--jen-text);
                margin-bottom: 4px;
                font-variant-numeric: tabular-nums;
            }
            
            .stats-label {
                color: var(--jen-text-light);
                font-weight: 500;
                font-size: 0.78rem;
                text-transform: none;
                letter-spacing: 0.1px;
            }
        </style>
        @livewireStyles
    </head>
    <body>
        <div class="min-vh-100">
            @include('layouts.navigation')

            <!-- Page Heading -->
            @isset($header)
                <header class="bg-white shadow-sm border-bottom">
                    <div class="container py-4">
                        {{ $header }}
                    </div>
                </header>
            @endisset

            <!-- Page Content -->
            <main>
                {{ $slot }}
            </main>
        </div>
        
        @livewireScripts
    </body>
</html>
